/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CashCouponCheckedProcessor
extends AbstractBossAccountHandle {
    private static final Logger log = LoggerFactory.getLogger(CashCouponCheckedProcessor.class);
    @Resource
    private BossAccountCacheService bossAccountCacheService;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (context.getReceiveMoney() == null) {
            return Message.build((boolean)false);
        }
        return Message.build();
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        int flag;
        int times = 0;
        do {
            MerchantAccountEntity accountEntity = super.accountEntity(context);
            BigDecimal drawableCash = accountEntity.getDrawableCash();
            BigDecimal totalCash = accountEntity.getTotalCash();
            if (null == drawableCash) {
                drawableCash = BigDecimal.ZERO;
            }
            if (null == totalCash) {
                totalCash = BigDecimal.ZERO;
            }
            accountEntity.setDrawableCash(drawableCash.add(context.getReceiveMoney()));
            accountEntity.setTotalCash(totalCash.add(context.getReceiveMoney()));
            accountEntity.setVersion(accountEntity.getVersion());
            flag = this.merchantAccountMapper.updateByPrimaryKeySelective(accountEntity);
            ++times;
            if (!log.isDebugEnabled()) continue;
            log.debug("\u5546\u6237id:{}, \u6536\u76ca\u91d1\u989d\uff1a{}", (Object)context.getMerchantId(), (Object)context.getReceiveMoney());
            log.debug("\u5546\u6237id:{}, \u4fee\u6539\u8d26\u6237\u4fe1\u606f\uff1a{}", (Object)context.getMerchantId(), (Object)JSON.toJSONString((Object)accountEntity));
        } while (flag <= 0 && times < 3);
        if (flag <= 0) {
            throw new BusinessException("\u8d26\u6237\u53d8\u66f4\u5931\u8d25\uff01");
        }
        this.bossAccountCacheService.cacheAccountToday(context.getMerchantId(), context.getReceiveMoney());
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.addCash(context, MerchantBossAccountCashTypeEnum.PLATFORM_SUBSIDY, context.getReceiveMoney(), "\u7528\u6237\u4f7f\u7528\u73b0\u91d1\u7ea2\u5305\u8865\u8d34", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
        this.addCash(context, MerchantBossAccountCashTypeEnum.REWARD_CASH_INCOME_CHARGE, context.getServiceMoney().negate(), "\u73b0\u91d1\u7ea2\u5305\u8865\u8d34\u624b\u7eed\u8d39", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.CASH_COUPON_CHECKED;
    }
}

