/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BossAccountCacheServiceImpl
implements BossAccountCacheService {
    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Override
    public void cacheAccountToday(Long merchantId, BigDecimal amount) {
        BigDecimal amountToday = (BigDecimal)this.redisStringAdapter.get(this.cacheKey(merchantId), BigDecimal.class);
        if (Objects.isNull(amountToday)) {
            this.redisStringAdapter.set(this.cacheKey(merchantId), (Object)amount, DateUtils.getTodayEndMillis() / 1000L);
        } else {
            this.redisStringAdapter.set(this.cacheKey(merchantId), (Object)amountToday.add(amount), DateUtils.getTodayEndMillis() / 1000L);
        }
    }

    @Override
    public BigDecimal getAccountTodayCache(Long merchantId) {
        BigDecimal amountToday = (BigDecimal)this.redisStringAdapter.get(this.cacheKey(merchantId), BigDecimal.class);
        if (Objects.nonNull(amountToday)) {
            return amountToday;
        }
        return new BigDecimal("0");
    }

    @Override
    public void removeAccountTotal(Long merchantId) {
        this.redisStringAdapter.remove(RedisConfig.MERCHANT_ACCOUNT_TOTAL.copy().appendKey((Object)merchantId));
    }

    private KeyGenerator cacheKey(Long merchantId) {
        return RedisConfig.MERCHANT_ACCOUNT_TODAY.copy().appendKey((Object)merchantId);
    }
}

