/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.impl.accountdetail;

import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.dto.account.MerchantOrderDetailDTO;
import com.bxm.localnews.merchant.service.account.boss.impl.accountdetail.AbstractOrderDetail;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderManageProcess {
    private HashMap<Integer, AbstractOrderDetail> orderDetailHashMap;
    private static HashMap<String, Integer> cashTypeEnumMap = new HashMap(9);

    public Integer cashTypeEnum(String cashType) {
        return cashTypeEnumMap.getOrDefault(cashType, 1);
    }

    @Autowired
    public OrderManageProcess(List<AbstractOrderDetail> listOrderDetail) {
        this.orderDetailHashMap = new HashMap(listOrderDetail.size());
        listOrderDetail.forEach(entity -> this.orderDetailHashMap.put(entity.getType(), (AbstractOrderDetail)entity));
    }

    public MerchantOrderDetailDTO getOrderDetail(String cashTypeEnum, Long relationId) {
        Integer type = this.cashTypeEnum(cashTypeEnum);
        return this.orderDetailHashMap.get(type).getDetailByRelationId(relationId);
    }

    static {
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_PAYMENT.name(), 1);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_INCOME_CHARGE.name(), 1);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_SUCCESS.name(), 2);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_FALSE.name(), 2);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_DIVIDE.name(), 1);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_ING.name(), 2);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_DRAWBACK.name(), 1);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_OUT_CHARGE.name(), 1);
        cashTypeEnumMap.put(MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_SUCCESS_CHARGE.name(), 1);
    }
}

