/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.base.impl;

import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.dto.IndustryDTO;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.param.IndustryInfoParam;
import com.bxm.localnews.merchant.param.IndustryOperatorParam;
import com.bxm.localnews.merchant.service.base.IndustryService;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IndustryServiceImpl
implements IndustryService {
    private MerchantCategoryMapper merchantCategoryMapper;

    @Override
    public List<IndustryDTO> getListAll(IndustryInfoParam industryInfoParam) {
        List listAll = this.merchantCategoryMapper.selectList(industryInfoParam.getCatName(), industryInfoParam.getStatus());
        ArrayList<IndustryDTO> listDtoAll = new ArrayList<IndustryDTO>();
        if (!CollectionUtils.isEmpty((Collection)listAll)) {
            listAll.forEach(entity -> listDtoAll.add(this.convert((MerchantCategoryEntity)entity)));
        }
        return listDtoAll;
    }

    @Override
    public PageWarper<IndustryDTO> getListPage(IndustryInfoParam industryInfoParam) {
        PageHelper.startPage((int)industryInfoParam.getPageNum(), (int)industryInfoParam.getPageSize());
        PageWarper pageList = new PageWarper(this.merchantCategoryMapper.selectPageList(industryInfoParam));
        PageWarper pageDtoList = new PageWarper();
        ArrayList listDtoAll = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)pageList.getList())) {
            pageList.getList().forEach(entity -> listDtoAll.add(this.convert((MerchantCategoryEntity)entity)));
        }
        BeanUtils.copyProperties((Object)pageList, (Object)pageDtoList);
        pageDtoList.setList(listDtoAll);
        return pageDtoList;
    }

    @Override
    public IndustryDTO getById(Long id) {
        MerchantCategoryEntity entity = this.merchantCategoryMapper.selectByPrimaryKey(id);
        return this.convert(entity);
    }

    @Override
    public Boolean updatePrice(IndustryOperatorParam industryOperatorParam) {
        MerchantCategoryEntity entity = new MerchantCategoryEntity();
        entity.setId(industryOperatorParam.getId());
        entity.setCatImg(industryOperatorParam.getImgUrl());
        entity.setCatName(industryOperatorParam.getName());
        entity.setVipPrice(new BigDecimal(industryOperatorParam.getPrice()));
        return this.merchantCategoryMapper.updateByPrimaryKeySelective(entity) > 0;
    }

    private IndustryDTO convert(MerchantCategoryEntity entity) {
        IndustryDTO industryDTO = new IndustryDTO();
        if (null == entity) {
            return industryDTO;
        }
        industryDTO.setId(entity.getId());
        industryDTO.setImgUrl(entity.getCatImg());
        industryDTO.setName(entity.getCatName());
        industryDTO.setPrice(entity.getVipPrice());
        return industryDTO;
    }

    public IndustryServiceImpl(MerchantCategoryMapper merchantCategoryMapper) {
        this.merchantCategoryMapper = merchantCategoryMapper;
    }
}

