/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.count.impl;

import com.bxm.localnews.merchant.domain.MerchantActionRecordMapper;
import com.bxm.localnews.merchant.dto.ActionRecordTraceIdDTO;
import com.bxm.localnews.merchant.dto.MerchantCounterClueDTO;
import com.bxm.localnews.merchant.dto.RelationImplDTO;
import com.bxm.localnews.merchant.entity.MerchantActionRecordEntity;
import com.bxm.localnews.merchant.param.MerchantCounterClueParam;
import com.bxm.localnews.merchant.security.facade.dto.RelationshipDto;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.service.count.MerchantActionRecordService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MerchantActionRecordServiceImpl
implements MerchantActionRecordService {
    private static final Logger log = LoggerFactory.getLogger(MerchantActionRecordServiceImpl.class);
    private MerchantActionRecordMapper merchantActionRecordMapper;
    private MerchantMemberFacadeService merchantMemberFacadeService;
    private SequenceCreater sequenceCreater;

    @Override
    public int save(MerchantActionRecordEntity merchantActionRecordEntity) {
        merchantActionRecordEntity.setId(this.sequenceCreater.nextLongId());
        return this.merchantActionRecordMapper.insert(merchantActionRecordEntity);
    }

    @Override
    public MerchantActionRecordEntity getByTraceId(String traceId) {
        return this.merchantActionRecordMapper.getByTraceId(traceId);
    }

    @Override
    public PageWarper<MerchantCounterClueDTO> getCluePageList(MerchantCounterClueParam merchantCounterClueParam) {
        MerchantMemberVo merchantMemberVo = this.merchantMemberFacadeService.getMemberInfo(merchantCounterClueParam.getUserId());
        if (Objects.isNull(merchantMemberVo)) {
            return new PageWarper();
        }
        merchantCounterClueParam.setRole(merchantMemberVo.getRole());
        return new PageWarper(this.merchantActionRecordMapper.getCluePageList(merchantCounterClueParam));
    }

    @Override
    public String getTraceByRidBelonger(ActionRecordTraceIdDTO actionRecordTraceIdDTO) {
        RelationshipDto relationshipDto = this.merchantMemberFacadeService.getRelationship(actionRecordTraceIdDTO.getBelonger());
        if (null != relationshipDto) {
            RelationImplDTO relationImplDTO = this.convertRelationShipDto(relationshipDto);
            actionRecordTraceIdDTO.setBelonger(relationImplDTO.getBelonger());
            return this.merchantActionRecordMapper.getTraceByRidBelonger(actionRecordTraceIdDTO);
        }
        return "";
    }

    @Override
    public Boolean updateRelationStatus(Long userId, Long merchantId, Byte status) {
        return true;
    }

    @Override
    public RelationImplDTO convertRelationShipDto(RelationshipDto relationshipDto) {
        if (null == relationshipDto) {
            return null;
        }
        RelationImplDTO relationImplDTO = new RelationImplDTO();
        switch (relationshipDto.getType()) {
            case 0: {
                relationImplDTO.setOperator(relationshipDto.getBossUserId());
                relationImplDTO.setBelonger(relationshipDto.getBossUserId());
                relationImplDTO.setActor(relationshipDto.getBossUserId() + "");
                break;
            }
            case 1: {
                relationImplDTO.setBelonger(relationshipDto.getEmployeeUserId());
                relationImplDTO.setActor(relationshipDto.getEmployeeUserId() + "");
                relationImplDTO.setOperator(relationshipDto.getEmployeeUserId());
                break;
            }
            case 2: {
                relationImplDTO.setBelonger(relationshipDto.getBossUserId());
                relationImplDTO.setActor(relationshipDto.getInviteSuperUserId() + "");
                relationImplDTO.setOperator(relationshipDto.getBossUserId());
                break;
            }
            case 3: {
                relationImplDTO.setBelonger(relationshipDto.getEmployeeUserId());
                relationImplDTO.setActor(relationshipDto.getInviteSuperUserId() + "");
                relationImplDTO.setOperator(relationshipDto.getEmployeeUserId());
                break;
            }
        }
        relationImplDTO.setMerchantId(relationshipDto.getMerchantId());
        relationImplDTO.setType(relationshipDto.getType());
        return relationImplDTO;
    }

    public MerchantActionRecordServiceImpl(MerchantActionRecordMapper merchantActionRecordMapper, MerchantMemberFacadeService merchantMemberFacadeService, SequenceCreater sequenceCreater) {
        this.merchantActionRecordMapper = merchantActionRecordMapper;
        this.merchantMemberFacadeService = merchantMemberFacadeService;
        this.sequenceCreater = sequenceCreater;
    }
}

