/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.bxm.localnews.merchant.common.enums.GoodsCommissionTypeEnum;
import com.bxm.localnews.merchant.config.ActivityGoodsProperties;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.goods.CalculateUserCommissionDTO;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.goods.activity.DiscountGroupGoodsQueryParam;
import com.bxm.localnews.merchant.service.goods.DiscountGroupGoodsService;
import com.bxm.localnews.merchant.utils.GoodsPriceRelatedUtils;
import com.bxm.localnews.merchant.vo.goods.activity.DiscountGroupGoodsVO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DiscountGroupGoodsServiceImpl
implements DiscountGroupGoodsService {
    private static final Logger log = LoggerFactory.getLogger(DiscountGroupGoodsServiceImpl.class);
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final MerchantInfoFacadeService merchantInfoDbService;
    private final UserIntegrationService userIntegrationService;
    private final ActivityGoodsProperties activityGoodsProperties;

    @Override
    public List<DiscountGroupGoodsVO> getList(DiscountGroupGoodsQueryParam param) {
        List resultList = this.merchantGoodsCategoryRelationMapper.getDiscountGroupGoodsList(param.getAreaCode(), param.getQueryType(), param.getIndustryId(), this.activityGoodsProperties.getSavePageDiscountGoodsCount());
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        resultList.forEach(groupGoodsVO -> {
            String headPics = groupGoodsVO.getHeadPics();
            String[] headImg = headPics.split(",");
            groupGoodsVO.setGoodsImg(headImg[0]);
            MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(groupGoodsVO.getMerchantId());
            groupGoodsVO.setMerchantName(merchantInfo.getMerchantName());
            BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(groupGoodsVO.getPrice(), groupGoodsVO.getVipDiscount());
            groupGoodsVO.setVipPrice(vipPrice);
            CalculateUserCommissionDTO calculateUserCommissionDTO = CalculateUserCommissionDTO.builder().commissionType(GoodsCommissionTypeEnum.RATE.getCode()).commissionRate(groupGoodsVO.getCommissionRate()).price(Objects.equals(userInfoDTO.getIsVip(), 1) ? vipPrice : groupGoodsVO.getPrice()).talentLevel(userInfoDTO.getTalentLevel()).groupCommission(Boolean.valueOf(false)).build();
            groupGoodsVO.setCommission(GoodsPriceRelatedUtils.getUserResultCommission(calculateUserCommissionDTO));
        });
        return resultList;
    }

    public DiscountGroupGoodsServiceImpl(MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, MerchantInfoFacadeService merchantInfoDbService, UserIntegrationService userIntegrationService, ActivityGoodsProperties activityGoodsProperties) {
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.merchantInfoDbService = merchantInfoDbService;
        this.userIntegrationService = userIntegrationService;
        this.activityGoodsProperties = activityGoodsProperties;
    }
}

