/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.common.enums.GoodsCommissionTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsInfoProperties;
import com.bxm.localnews.merchant.constant.DistributedKey;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsMemberDayMapper;
import com.bxm.localnews.merchant.entity.goods.MemberDayGoodsCategoryExtDataDTO;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsMemberDayEntity;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsManageQueryParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsOfflineParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsUpdateParam;
import com.bxm.localnews.merchant.service.goods.MemberDayGoodsManageService;
import com.bxm.localnews.merchant.service.goods.cache.MemberDayGoodsCacheManage;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.GoodAddStrategyManage;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchant.vo.goods.manage.MemberDayGoodsDetailVO;
import com.bxm.localnews.merchant.vo.goods.manage.MemberDayGoodsManageVO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.exceptions.BusinessException;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class MemberDayGoodsManageServiceImpl
implements MemberDayGoodsManageService {
    private final MerchantGoodsMapper merchantGoodsMapper;
    private final SequenceCreater sequenceCreater;
    private final MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper;
    private final GoodAddStrategyManage goodAddStrategyManage;
    private final MerchantInfoFacadeService merchantInfoDbService;
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final MemberDayGoodsCacheManage memberDayGoodsCacheManage;
    private final MerchantGoodsInfoProperties merchantGoodsInfoProperties;
    private final DistributedLock lock;

    @Override
    public PageWarper<MemberDayGoodsManageVO> getMemberDayGoodsList(MemberDayGoodsManageQueryParam queryParam) {
        Page memberGoodsWarper = PageMethod.startPage((Object)queryParam).doSelectPage(() -> this.merchantGoodsCategoryRelationMapper.getMemberDayGoodsList(queryParam));
        List resultVoList = memberGoodsWarper.getResult().stream().map(memberGoodsManageListDTO -> {
            MemberDayGoodsManageVO itemVO = new MemberDayGoodsManageVO();
            BeanUtils.copyProperties((Object)memberGoodsManageListDTO, (Object)itemVO);
            String extData = memberGoodsManageListDTO.getExtData();
            itemVO.setDiscountDay(this.getWeeksDayInfo(extData));
            itemVO.setSaleNum(Integer.valueOf(memberGoodsManageListDTO.getTotalNum() - memberGoodsManageListDTO.getNum()));
            return itemVO;
        }).collect(Collectors.toList());
        PageWarper resultWarper = new PageWarper((List)memberGoodsWarper);
        resultWarper.setList(resultVoList);
        return resultWarper;
    }

    @Override
    public MemberDayGoodsDetailVO queryGoods(Long goodsId) {
        if (Objects.isNull(goodsId)) {
            throw new BusinessException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MemberDayGoodsDetailVO resultVO = new MemberDayGoodsDetailVO();
        this.fillGoodsDetailInfo(goodsId, resultVO);
        this.fillGoodsCategoryInfo(goodsId, resultVO);
        this.fillMemberDayInfo(goodsId, resultVO);
        return resultVO;
    }

    private void fillMemberDayInfo(Long goodsId, MemberDayGoodsDetailVO resultVO) {
        List memberDayInfo = this.merchantGoodsMemberDayMapper.getListByGoodsId(goodsId);
        List weekDays = memberDayInfo.stream().map(m -> {
            MemberDayGoodsDetailVO.WeekInfo itemVO = new MemberDayGoodsDetailVO.WeekInfo();
            itemVO.setWeekCount(m.getWeekCount());
            itemVO.setWeekName(this.getWeekNameByCount(m.getWeekCount()));
            return itemVO;
        }).collect(Collectors.toList());
        resultVO.setWeekDays(weekDays);
    }

    private void fillGoodsCategoryInfo(Long goodsId, MemberDayGoodsDetailVO resultVO) {
        String extData;
        MemberDayGoodsCategoryExtDataDTO extDataDTO;
        MerchantGoodsCategoryRelationEntity categoryInfo = this.merchantGoodsCategoryRelationMapper.getByGoodsIdAndType(goodsId, GoodsCategoryTypeEnum.MEMBER_DAY.getCode());
        resultVO.setSourceGoodsId(categoryInfo.getSourceGoodsId());
        resultVO.setOrder(categoryInfo.getOrder());
        if (Objects.nonNull(categoryInfo.getSourceGoodsId())) {
            MerchantGoodsVo sourceGoodsInfo = this.merchantGoodsMapper.selectByPrimaryKey(categoryInfo.getSourceGoodsId());
            resultVO.setSourceGoodsName(sourceGoodsInfo.getName());
        }
        resultVO.setBigTalentCommission((extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)(extData = categoryInfo.getExtData()), MemberDayGoodsCategoryExtDataDTO.class)).getBigTalentCommission() == null ? BigDecimal.ZERO : extDataDTO.getBigTalentCommission());
        resultVO.setNoBigTalentCommission(extDataDTO.getNoBigTalentCommission() == null ? BigDecimal.ZERO : extDataDTO.getNoBigTalentCommission());
        resultVO.setTeamCommission(extDataDTO.getTeamCommission() == null ? BigDecimal.ZERO : extDataDTO.getTeamCommission());
        resultVO.setBaseSaleCount(extDataDTO.getBaseSaleCount());
    }

    private void fillGoodsDetailInfo(Long goodsId, MemberDayGoodsDetailVO resultVO) {
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(goodsId);
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)resultVO);
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        resultVO.setPosterStatus(Boolean.valueOf(merchantGoodsVo.getPosterStatus() == 1));
        resultVO.setMerchantName(merchantInfo.getMerchantName());
        resultVO.setGoodsId(merchantGoodsVo.getId());
        resultVO.setGoodsName(merchantGoodsVo.getName());
        resultVO.setDiscountTitle(merchantGoodsVo.getName());
        resultVO.setDistributionAmount(merchantGoodsVo.getCommissionAmount());
        resultVO.setSaleNum(Integer.valueOf(merchantGoodsVo.getTotalNum() - merchantGoodsVo.getNum()));
    }

    @Override
    public Message create(MemberDayGoodsCreateParam memberDayGoodsCreateParam) {
        if (memberDayGoodsCreateParam.getDiscountTitle().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        Message message = this.setMemberDayCommission(memberDayGoodsCreateParam.getBigTalentCommission(), memberDayGoodsCreateParam.getNoBigTalentCommission(), memberDayGoodsCreateParam.getTeamCommission(), memberDayGoodsCreateParam.getDistributionAmount());
        if (!message.isSuccess()) {
            return message;
        }
        GoodsAddContext context = GoodsAddContext.builder().categoryType(GoodsCategoryTypeEnum.MEMBER_DAY.getCode()).memberDayGoodsCreateParam(memberDayGoodsCreateParam).goodsCreateParam(this.convertGoodsCreateParam(memberDayGoodsCreateParam)).build();
        return this.goodAddStrategyManage.execute(context);
    }

    @Override
    public Message update(MemberDayGoodsUpdateParam goodsUpdateManageParam) {
        long repeatCommitTimeLimit;
        String requestId;
        Long goodsId = goodsUpdateManageParam.getGoodsId();
        if (goodsUpdateManageParam.getDiscountTitle().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        Message message = this.setMemberDayCommission(goodsUpdateManageParam.getBigTalentCommission(), goodsUpdateManageParam.getNoBigTalentCommission(), goodsUpdateManageParam.getTeamCommission(), goodsUpdateManageParam.getDistributionAmount());
        if (!message.isSuccess()) {
            return message;
        }
        String resourceKey = this.genUpdateGoodsLockKey(goodsId);
        if (this.lock.lock(resourceKey, requestId = this.sequenceCreater.nextStringId(), repeatCommitTimeLimit = 2L, TimeUnit.SECONDS)) {
            this.updateGoodInfo(goodsUpdateManageParam, goodsId);
            this.updateGoodsCategoryInfo(goodsUpdateManageParam);
            this.updateMemberDayInfo(goodsUpdateManageParam, goodsId);
            this.lock.unlock(resourceKey, requestId);
        }
        return Message.build((boolean)true);
    }

    private String genUpdateGoodsLockKey(Long goodsId) {
        return DistributedKey.UPDATE_GOODS_MANAGE.copy().appendKey((Object)goodsId).gen();
    }

    private Integer countTotalNum(Integer num, MerchantGoodsVo merchantGoodsVo) {
        Integer totalNum = merchantGoodsVo.getTotalNum();
        Integer oldNum = merchantGoodsVo.getNum();
        if (!Objects.equals(oldNum, num)) {
            if (num > oldNum) {
                int result = num - oldNum;
                totalNum = totalNum + result;
            } else {
                int result = oldNum - num;
                totalNum = totalNum - result;
            }
        }
        return totalNum;
    }

    private void updateMemberDayInfo(MemberDayGoodsUpdateParam goodsUpdateManageParam, Long goodsId) {
        String weekDays = goodsUpdateManageParam.getWeekDays();
        if (StringUtils.isNotBlank((CharSequence)weekDays)) {
            String[] weekDaysInfo;
            this.merchantGoodsMemberDayMapper.deleteByGoodsId(goodsId);
            for (String weekDayItem : weekDaysInfo = weekDays.split(",")) {
                MerchantGoodsMemberDayEntity targetItem = new MerchantGoodsMemberDayEntity();
                targetItem.setId(this.sequenceCreater.nextLongId());
                targetItem.setGoodsId(goodsId);
                targetItem.setWeekCount(Integer.valueOf(weekDayItem));
                this.merchantGoodsMemberDayMapper.insertSelective(targetItem);
            }
        }
    }

    private void updateGoodsCategoryInfo(MemberDayGoodsUpdateParam goodsUpdateManageParam) {
        MerchantGoodsCategoryRelationEntity categoryUpdateEntity = new MerchantGoodsCategoryRelationEntity();
        MemberDayGoodsCategoryExtDataDTO extDataDTO = new MemberDayGoodsCategoryExtDataDTO();
        extDataDTO.setWeekDays(goodsUpdateManageParam.getWeekDays());
        extDataDTO.setBaseSaleCount(goodsUpdateManageParam.getBaseSaleCount());
        categoryUpdateEntity.setGoodsId(goodsUpdateManageParam.getGoodsId());
        categoryUpdateEntity.setType(GoodsCategoryTypeEnum.MEMBER_DAY.getCode());
        categoryUpdateEntity.setExtData(JSON.toJSONString((Object)extDataDTO));
        categoryUpdateEntity.setOrder(goodsUpdateManageParam.getOrder());
        this.merchantGoodsCategoryRelationMapper.updateSelectiveByGoodsIdAndType(categoryUpdateEntity);
    }

    @Retryable(value={RetryException.class})
    private void updateGoodInfo(MemberDayGoodsUpdateParam goodsUpdateManageParam, Long goodsId) {
        MerchantGoodsVo currentMerchantGoodsVo = this.merchantGoodsMapper.getGoodsInfoById(goodsId);
        MerchantGoodsVo goodsUpdateVO = new MerchantGoodsVo();
        goodsUpdateVO.setId(goodsId);
        goodsUpdateVO.setName(goodsUpdateManageParam.getDiscountTitle());
        goodsUpdateVO.setOriginalPrice(goodsUpdateManageParam.getOriginalPrice());
        goodsUpdateVO.setPrice(goodsUpdateManageParam.getPrice());
        goodsUpdateVO.setCommissionAmount(goodsUpdateManageParam.getDistributionAmount());
        goodsUpdateVO.setNum(goodsUpdateManageParam.getNum());
        goodsUpdateVO.setHeadPics(goodsUpdateManageParam.getHeadPics());
        goodsUpdateVO.setDetail(goodsUpdateManageParam.getDetail());
        goodsUpdateVO.setPosterUrl(goodsUpdateManageParam.getPosterUrl());
        goodsUpdateVO.setPosterName(goodsUpdateManageParam.getPosterName());
        goodsUpdateVO.setPosterStatus(Integer.valueOf(Objects.equals(goodsUpdateManageParam.getPosterStatus(), Boolean.TRUE) ? 1 : 0));
        goodsUpdateVO.setTotalNum(this.countTotalNum(goodsUpdateManageParam.getNum(), currentMerchantGoodsVo));
        goodsUpdateVO.setModifyTime(new Date());
        goodsUpdateVO.setVersion(Objects.nonNull(currentMerchantGoodsVo.getVersion()) ? currentMerchantGoodsVo.getVersion() : null);
        goodsUpdateVO.setSupportRefund(goodsUpdateManageParam.getSupportRefund() == null ? Boolean.TRUE : goodsUpdateManageParam.getSupportRefund());
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsUpdateVO) <= 0) {
            throw new RetryException("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        this.memberDayGoodsCacheManage.resetCountActivityCount(currentMerchantGoodsVo.getMerchantId());
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsId.toString()});
    }

    @Override
    public Boolean offline(MemberDayGoodsOfflineParam param) {
        if (Objects.isNull(param.getGoodsId())) {
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(param.getGoodsId());
        MerchantGoodsCategoryRelationEntity currentMemberDayGoodsInfo = this.merchantGoodsCategoryRelationMapper.getByGoodsIdAndType(param.getGoodsId(), GoodsCategoryTypeEnum.MEMBER_DAY.getCode());
        if (currentMemberDayGoodsInfo.getStatus().equals(param.getStatus())) {
            return true;
        }
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        return this.merchantGoodsCategoryRelationMapper.updateStatusByGoodsIdAndType(param.getGoodsId(), param.getStatus(), GoodsCategoryTypeEnum.MEMBER_DAY.getCode()) > 0;
    }

    private GoodsCreateParam convertGoodsCreateParam(MemberDayGoodsCreateParam memberDayGoodsCreateParam) {
        GoodsCreateParam goodsCreateParam = new GoodsCreateParam();
        goodsCreateParam.setMerchantId(memberDayGoodsCreateParam.getMerchantId());
        goodsCreateParam.setName(memberDayGoodsCreateParam.getDiscountTitle());
        goodsCreateParam.setOriginalPrice(memberDayGoodsCreateParam.getOriginalPrice());
        goodsCreateParam.setPrice(memberDayGoodsCreateParam.getPrice());
        goodsCreateParam.setDetail(memberDayGoodsCreateParam.getDetail());
        goodsCreateParam.setHeadPics(memberDayGoodsCreateParam.getHeadPics());
        goodsCreateParam.setNum(memberDayGoodsCreateParam.getNum());
        goodsCreateParam.setPosterUrl(memberDayGoodsCreateParam.getPosterUrl());
        goodsCreateParam.setPosterName(memberDayGoodsCreateParam.getPosterName());
        goodsCreateParam.setPosterStatus(Integer.valueOf(Objects.equals(memberDayGoodsCreateParam.getPosterStatus(), Boolean.TRUE) ? 1 : 0));
        goodsCreateParam.setVipDiscount(Integer.valueOf(0));
        goodsCreateParam.setCommissionAmount(memberDayGoodsCreateParam.getDistributionAmount());
        goodsCreateParam.setCommissionType(GoodsCommissionTypeEnum.AMOUNT.getCode());
        return goodsCreateParam;
    }

    private String getWeeksDayInfo(String extData) {
        MemberDayGoodsCategoryExtDataDTO extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)extData, MemberDayGoodsCategoryExtDataDTO.class);
        String weekDays = extDataDTO.getWeekDays();
        String[] weekDaysInfo = weekDays.split(",");
        StringBuilder weekDaysBuilder = new StringBuilder();
        for (String weekDay : weekDaysInfo) {
            String weekNameByCount = this.getWeekNameByCount(Integer.parseInt(weekDay));
            weekDaysBuilder.append(weekNameByCount).append("\u3001");
        }
        String weekDaysStr = weekDaysBuilder.toString();
        if (StringUtils.isNotBlank((CharSequence)weekDaysStr) && weekDaysStr.length() > 1) {
            weekDaysStr = weekDaysStr.substring(0, weekDaysStr.length() - 1);
        }
        return weekDaysStr;
    }

    private String getWeekNameByCount(int weekDay) {
        if (1 == weekDay) {
            return "\u661f\u671f\u4e00";
        }
        if (2 == weekDay) {
            return "\u661f\u671f\u4e8c";
        }
        if (3 == weekDay) {
            return "\u661f\u671f\u4e09";
        }
        if (4 == weekDay) {
            return "\u661f\u671f\u56db";
        }
        if (5 == weekDay) {
            return "\u661f\u671f\u4e94";
        }
        if (6 == weekDay) {
            return "\u661f\u671f\u516d";
        }
        if (0 == weekDay) {
            return "\u661f\u671f\u65e5";
        }
        return "";
    }

    private Message setMemberDayCommission(BigDecimal bigTalentCommission, BigDecimal noBigTalentCommission, BigDecimal teamCommission, BigDecimal distributionAmount) {
        if (noBigTalentCommission.compareTo(distributionAmount) > 0) {
            return Message.build((boolean)false).setMessage("\u5c0f&\u4e2d\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1,\u91d1\u989d\u9700\u5c0f\u4e8e\u5206\u9500\u91d1\u989d");
        }
        if (bigTalentCommission.compareTo(distributionAmount) > 0) {
            return Message.build((boolean)false).setMessage("\u5927\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1,\u4f63\u91d1\u91d1\u989d\u9700\u5c0f\u4e8e\u5206\u9500\u91d1\u989d");
        }
        if (noBigTalentCommission.compareTo(bigTalentCommission) > 0) {
            return Message.build((boolean)false).setMessage("\u5c0f&\u4e2d\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1,\u4f63\u91d1\u91d1\u989d\u9700\u5c0f\u4e8e\u5927\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1");
        }
        if (teamCommission.compareTo(distributionAmount) > 0) {
            return Message.build((boolean)false).setMessage("\u56e2\u961f\u4f63\u91d1,\u9700\u5c0f\u4e8e\u5206\u9500\u91d1\u989d");
        }
        if (teamCommission.compareTo(noBigTalentCommission) > 0) {
            return Message.build((boolean)false).setMessage("\u56e2\u961f\u4f63\u91d1,\u9700\u5c0f\u4e8e\u5c0f&\u4e2d\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1");
        }
        if (teamCommission.compareTo(bigTalentCommission) > 0) {
            return Message.build((boolean)false).setMessage("\u56e2\u961f\u4f63\u91d1,\u9700\u5c0f\u4e8e\u5927\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1");
        }
        if (bigTalentCommission.add(teamCommission.multiply(new BigDecimal(2))).compareTo(distributionAmount) > 0) {
            return Message.build((boolean)false).setMessage("\u5927\u8fbe\u4eba\u76f4\u8d2d\u4f63\u91d1+\u56e2\u961f\u4f63\u91d1*2<=\u5206\u9500\u91d1\u989d");
        }
        return Message.build((boolean)true);
    }

    public MemberDayGoodsManageServiceImpl(MerchantGoodsMapper merchantGoodsMapper, SequenceCreater sequenceCreater, MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper, GoodAddStrategyManage goodAddStrategyManage, MerchantInfoFacadeService merchantInfoDbService, MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, RedisHashMapAdapter redisHashMapAdapter, MemberDayGoodsCacheManage memberDayGoodsCacheManage, MerchantGoodsInfoProperties merchantGoodsInfoProperties, DistributedLock lock) {
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.sequenceCreater = sequenceCreater;
        this.merchantGoodsMemberDayMapper = merchantGoodsMemberDayMapper;
        this.goodAddStrategyManage = goodAddStrategyManage;
        this.merchantInfoDbService = merchantInfoDbService;
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.memberDayGoodsCacheManage = memberDayGoodsCacheManage;
        this.merchantGoodsInfoProperties = merchantGoodsInfoProperties;
        this.lock = lock;
    }
}

