/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.strategy;

import com.bxm.localnews.merchant.constant.DistributedKey;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.IGoodsAddStrategy;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.vo.Message;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GoodAddStrategyManage {
    private static final Logger log = LoggerFactory.getLogger(GoodAddStrategyManage.class);
    private final List<IGoodsAddStrategy> strategies;
    private final DistributedLock distributedLock;

    public GoodAddStrategyManage(List<IGoodsAddStrategy> strategies, DistributedLock distributedLock) {
        this.strategies = strategies;
        this.distributedLock = distributedLock;
    }

    @Transactional(rollbackFor={Exception.class})
    public Message execute(GoodsAddContext context) {
        long repeatCommitTimeLimit;
        String requestId;
        String resourceId;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u6dfb\u52a0\u5546\u54c1\uff0c\u5546\u54c1\u53c2\u6570\uff1a[{}]", (Object)context);
        }
        if (this.distributedLock.lock(resourceId = this.genAddGoodsLockKey(context.getGoodsCreateParam().getMerchantId()), requestId = UUID.randomUUID().toString(), repeatCommitTimeLimit = 2L, TimeUnit.SECONDS)) {
            for (IGoodsAddStrategy strategy : this.strategies) {
                if (!strategy.match(context)) continue;
                Message message = strategy.execute(context);
                this.distributedLock.unlock(resourceId, requestId);
                return message;
            }
        }
        return Message.build((boolean)false);
    }

    private String genAddGoodsLockKey(Long merchantId) {
        return DistributedKey.ADD_GOODS_MANAGE.copy().appendKey((Object)merchantId).gen();
    }
}

