/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.strategy.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsRecordMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsAreaRelationMapper;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsAreaRelationEntity;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsCreateParam;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.IGoodsAddStrategy;
import com.bxm.localnews.merchant.vo.MerchantGoodsRecordVO;
import com.bxm.localnews.merchant.vo.goods.GoodsSortVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.BeanUtils;

public abstract class AbstractGoodsAddStrategy
implements IGoodsAddStrategy {
    @Resource
    private MerchantGoodsMapper merchantGoodsMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private MerchantGoodsRecordMapper merchantGoodsRecordMapper;
    @Resource
    private MerchantInfoFacadeService merchantInfoDbService;
    @Resource
    private MerchantGoodsAreaRelationMapper merchantGoodsAreaRelationMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public Message execute(GoodsAddContext context) {
        Message beforeMsg = this.beforeAddGoods(context);
        if (Objects.equals(Boolean.FALSE, beforeMsg.isSuccess())) {
            return beforeMsg;
        }
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        BeanUtils.copyProperties((Object)context.getGoodsCreateParam(), (Object)merchantGoodsVo);
        Long goodsId = this.sequenceCreater.nextLongId();
        merchantGoodsVo.setId(goodsId);
        merchantGoodsVo.setCreateTime(new Date());
        merchantGoodsVo.setTotalNum(merchantGoodsVo.getNum());
        merchantGoodsVo.setVersion(Integer.valueOf(0));
        if (GoodsCategoryTypeEnum.MEMBER_DAY.getCode().equals(context.getCategoryType())) {
            merchantGoodsVo.setShelfType(Integer.valueOf(1));
            merchantGoodsVo.setQualificationStatus(Integer.valueOf(2));
        } else {
            merchantGoodsVo.setShelfType(Integer.valueOf(0));
            merchantGoodsVo.setQualificationStatus(Integer.valueOf(1));
        }
        int gazePeopleNum = RandomUtils.nextInt((int)500, (int)999);
        merchantGoodsVo.setGazePeopleNum(Integer.valueOf(gazePeopleNum));
        GoodsSortVo goodsSortVo = this.merchantGoodsMapper.selectSortByMerchantId(merchantGoodsVo.getMerchantId());
        merchantGoodsVo.setSort(Integer.valueOf(Objects.isNull(goodsSortVo) ? 1 : goodsSortVo.getSort() + 1));
        MemberDayGoodsCreateParam memberDayGoodsCreateParam = context.getMemberDayGoodsCreateParam();
        if (memberDayGoodsCreateParam != null) {
            merchantGoodsVo.setSupportRefund(context.getMemberDayGoodsCreateParam().getSupportRefund() == null ? Boolean.TRUE : context.getMemberDayGoodsCreateParam().getSupportRefund());
        }
        this.merchantGoodsMapper.insertSelective(merchantGoodsVo);
        context.getGoodsCreateParam().setGoodsId(goodsId);
        context.setMerchantGoodsVo(merchantGoodsVo);
        this.redisHashMapAdapter.put(RedisConfig.MERCHANT_GOODS_KEY, goodsId + "", (Object)merchantGoodsVo);
        this.addLog(context.getMerchantGoodsVo());
        this.afterAddGoods(context);
        return Message.build((boolean)true);
    }

    protected void addLog(MerchantGoodsVo merchantGoodsVo) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = new MerchantGoodsRecordVO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantGoodsRecordVO);
        merchantGoodsRecordVO.setGoodsId(merchantGoodsVo.getId());
        merchantGoodsRecordVO.setId(null);
        merchantGoodsRecordVO.setCreateTime(new Date());
        this.merchantGoodsRecordMapper.insertSelective(merchantGoodsRecordVO);
    }

    protected void saveGoodsAreaInfo(GoodsCreateParam goodsCreateParam) {
        MerchantInfo currentMerchantInfo = this.merchantInfoDbService.getMerchantInfo(goodsCreateParam.getMerchantId());
        MerchantGoodsAreaRelationEntity goodsAreaRelationInfo = new MerchantGoodsAreaRelationEntity();
        goodsAreaRelationInfo.setAreaCode(currentMerchantInfo.getAreaCode());
        goodsAreaRelationInfo.setGoodsId(goodsCreateParam.getGoodsId());
        goodsAreaRelationInfo.setId(this.sequenceCreater.nextLongId());
        this.merchantGoodsAreaRelationMapper.insert(goodsAreaRelationInfo);
    }

    protected String goodsCheck(GoodsCreateParam goodsCreateParam) {
        if (goodsCreateParam.getNum() <= 0) {
            return "\u5e93\u5b58\u4e0d\u80fd\u4e3a0";
        }
        if (goodsCreateParam.getOriginalPrice().doubleValue() < 1.0) {
            return "\u539f\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a1\u5143";
        }
        if (goodsCreateParam.getOriginalPrice().doubleValue() < 0.01) {
            return "\u73b0\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a0.01\u5143";
        }
        if (goodsCreateParam.getPrice().doubleValue() > goodsCreateParam.getOriginalPrice().doubleValue()) {
            return "\u5546\u54c1\u73b0\u4ef7\u4e0d\u80fd\u5927\u4e8e\u539f\u4ef7";
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(goodsCreateParam.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            return "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        return null;
    }
}

