/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsMemberDayMapper;
import com.bxm.localnews.merchant.entity.goods.MemberDayGoodsCategoryExtDataDTO;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsMemberDayEntity;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsCreateParam;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.impl.AbstractGoodsAddStrategy;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MemberDayGoodsAddStrategy
extends AbstractGoodsAddStrategy {
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper;
    private final SequenceCreater sequenceCreater;

    @Override
    public Message beforeAddGoods(GoodsAddContext context) {
        String mes = this.goodsCheck(context.getGoodsCreateParam());
        if (StringUtils.isNotBlank((String)mes)) {
            return Message.build((boolean)false, (String)mes);
        }
        String memberDayMsg = this.checkMemberDayGoodsInfo(context);
        if (StringUtils.isNotBlank((String)memberDayMsg)) {
            return Message.build((boolean)false, (String)memberDayMsg);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message afterAddGoods(GoodsAddContext context) {
        this.saveGoodsCategoryInfo(context);
        this.saveGoodsAreaInfo(context.getGoodsCreateParam());
        this.saveMemberDayInfo(context);
        return Message.build((boolean)true);
    }

    private void saveMemberDayInfo(GoodsAddContext context) {
        String[] weekDaysInfo;
        MemberDayGoodsCreateParam memberDayGoodsCreateParam = context.getMemberDayGoodsCreateParam();
        String weekDays = memberDayGoodsCreateParam.getWeekDays();
        for (String weekCount : weekDaysInfo = weekDays.split(",")) {
            MerchantGoodsMemberDayEntity memberDayEntity = new MerchantGoodsMemberDayEntity();
            memberDayEntity.setId(this.sequenceCreater.nextLongId());
            memberDayEntity.setGoodsId(context.getGoodsCreateParam().getGoodsId());
            memberDayEntity.setWeekCount(Integer.valueOf(weekCount));
            this.merchantGoodsMemberDayMapper.insertSelective(memberDayEntity);
        }
    }

    @Override
    public boolean match(GoodsAddContext context) {
        return Objects.equals(GoodsCategoryTypeEnum.MEMBER_DAY.getCode(), context.getCategoryType());
    }

    private void saveGoodsCategoryInfo(GoodsAddContext context) {
        MemberDayGoodsCreateParam memberDayGoodsCreateParam = context.getMemberDayGoodsCreateParam();
        MerchantGoodsCategoryRelationEntity memberDayCategoryInfo = new MerchantGoodsCategoryRelationEntity();
        memberDayCategoryInfo.setType(GoodsCategoryTypeEnum.MEMBER_DAY.getCode());
        memberDayCategoryInfo.setGoodsId(context.getGoodsCreateParam().getGoodsId());
        memberDayCategoryInfo.setId(this.sequenceCreater.nextLongId());
        memberDayCategoryInfo.setSourceGoodsId(context.getMemberDayGoodsCreateParam().getSourceGoodsId());
        memberDayCategoryInfo.setOrder(context.getMemberDayGoodsCreateParam().getOrder());
        MemberDayGoodsCategoryExtDataDTO extDataDTO = new MemberDayGoodsCategoryExtDataDTO();
        extDataDTO.setBaseSaleCount(memberDayGoodsCreateParam.getBaseSaleCount());
        extDataDTO.setWeekDays(memberDayGoodsCreateParam.getWeekDays());
        extDataDTO.setTeamCommission(memberDayGoodsCreateParam.getTeamCommission());
        extDataDTO.setBigTalentCommission(memberDayGoodsCreateParam.getBigTalentCommission());
        extDataDTO.setNoBigTalentCommission(memberDayGoodsCreateParam.getNoBigTalentCommission());
        memberDayCategoryInfo.setExtData(JSON.toJSONString((Object)extDataDTO));
        this.merchantGoodsCategoryRelationMapper.insertSelective(memberDayCategoryInfo);
    }

    public String checkMemberDayGoodsInfo(GoodsAddContext context) {
        if (Objects.isNull(context.getGoodsCreateParam().getCommissionAmount())) {
            return "\u5546\u54c1\u7684\u4f63\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (context.getGoodsCreateParam().getCommissionAmount().doubleValue() < 0.0) {
            return "\u5546\u54c1\u7684\u4f63\u91d1\u6700\u5c11\u4e3a0";
        }
        return null;
    }

    public MemberDayGoodsAddStrategy(MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper, SequenceCreater sequenceCreater) {
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.merchantGoodsMemberDayMapper = merchantGoodsMemberDayMapper;
        this.sequenceCreater = sequenceCreater;
    }
}

