/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.strategy.impl;

import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.impl.AbstractGoodsAddStrategy;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrdinaryGoodsAddStrategy
extends AbstractGoodsAddStrategy {
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final SequenceCreater sequenceCreater;

    @Override
    public Message beforeAddGoods(GoodsAddContext context) {
        String mes = this.goodsCheck(context.getGoodsCreateParam());
        if (StringUtils.isNotBlank((String)mes)) {
            return Message.build((boolean)false, (String)mes);
        }
        String ordinaryCheckMsg = this.checkOrdinaryGoodsInfo(context);
        if (StringUtils.isNotBlank((String)ordinaryCheckMsg)) {
            return Message.build((boolean)false, (String)ordinaryCheckMsg);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message afterAddGoods(GoodsAddContext context) {
        this.saveGoodsCategoryInfo(context.getGoodsCreateParam().getGoodsId());
        this.saveGoodsAreaInfo(context.getGoodsCreateParam());
        if (context.getGoodsCreateParam().getHasDiscountGroup() != null && context.getGoodsCreateParam().getHasDiscountGroup().booleanValue()) {
            this.addDiscountGroupInfo(context.getGoodsCreateParam().getOrder(), context.getGoodsCreateParam().getGoodsId());
        }
        return Message.build((boolean)true);
    }

    @Override
    public boolean match(GoodsAddContext context) {
        return Objects.equals(GoodsCategoryTypeEnum.ORDINARY.getCode(), context.getCategoryType());
    }

    private void addDiscountGroupInfo(Integer order, Long goodsId) {
        MerchantGoodsCategoryRelationEntity discountGroupCategoryInfo = new MerchantGoodsCategoryRelationEntity();
        discountGroupCategoryInfo.setId(this.sequenceCreater.nextLongId());
        discountGroupCategoryInfo.setGoodsId(goodsId);
        discountGroupCategoryInfo.setOrder(order);
        discountGroupCategoryInfo.setType(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode());
        this.merchantGoodsCategoryRelationMapper.insertSelective(discountGroupCategoryInfo);
    }

    private void saveGoodsCategoryInfo(Long goodsId) {
        MerchantGoodsCategoryRelationEntity ordinaryCategoryInfo = new MerchantGoodsCategoryRelationEntity();
        ordinaryCategoryInfo.setType(GoodsCategoryTypeEnum.ORDINARY.getCode());
        ordinaryCategoryInfo.setGoodsId(goodsId);
        ordinaryCategoryInfo.setId(this.sequenceCreater.nextLongId());
        this.merchantGoodsCategoryRelationMapper.insertSelective(ordinaryCategoryInfo);
    }

    public String checkOrdinaryGoodsInfo(GoodsAddContext context) {
        if (Objects.isNull(context.getGoodsCreateParam().getCommissionRate())) {
            return "\u5546\u54c1\u7684\u4f63\u91d1\u91d1\u989d\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (context.getGoodsCreateParam().getCommissionRate() > MerchantGoodsEnum.GOODS_RATE_MAX.getType() || context.getGoodsCreateParam().getCommissionRate() < 1) {
            return "\u4f63\u91d1\u6bd4\u4f8b\uff0c\u6700\u4f4e\u4e0d\u5c0f\u4e8e1%\uff0c\u6700\u9ad8\u4e0d\u8d85\u8fc799%";
        }
        return null;
    }

    public OrdinaryGoodsAddStrategy(MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, SequenceCreater sequenceCreater) {
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.sequenceCreater = sequenceCreater;
    }
}

