/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.order.impl;

import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.merchant.common.enums.GroupOrderStates;
import com.bxm.localnews.merchant.common.enums.GroupOrderSubStates;
import com.bxm.localnews.merchant.config.MerchantOrderProperties;
import com.bxm.localnews.merchant.domain.MerchantOpenvipOrderMapper;
import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantOpenVipDTO;
import com.bxm.localnews.merchant.dto.MerchantOperatorOrderDTO;
import com.bxm.localnews.merchant.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.merchant.dto.PromoteMoneyDTO;
import com.bxm.localnews.merchant.dto.order.MerchantBuyPromoteDTO;
import com.bxm.localnews.merchant.dto.order.PaymentOrderDTO;
import com.bxm.localnews.merchant.entity.GroupOrderInfoFacadeVO;
import com.bxm.localnews.merchant.entity.MerchantOpenvipOrderEntity;
import com.bxm.localnews.merchant.events.GoodsOrderPaymentEvent;
import com.bxm.localnews.merchant.integration.MarketIntegrationService;
import com.bxm.localnews.merchant.integration.PaymentIntegrationService;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.localnews.merchant.param.MerchantOpenVipParam;
import com.bxm.localnews.merchant.param.MerchantOperatorOrderParam;
import com.bxm.localnews.merchant.param.order.AfterOrderPaySuccessParam;
import com.bxm.localnews.merchant.param.order.MerchantBuyOrderParam;
import com.bxm.localnews.merchant.param.order.UserOrderParam;
import com.bxm.localnews.merchant.service.base.InterestsService;
import com.bxm.localnews.merchant.service.count.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class MerchantOrderInfoServiceImpl
implements MerchantOrderInfoService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MerchantOrderInfoServiceImpl.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private PromoteService promoteService;
    @Resource
    private MerchantOpenvipOrderMapper merchantOpenvipOrderMapper;
    @Autowired
    private PaymentIntegrationService paymentIntegrationService;
    @Autowired
    private MarketIntegrationService marketIntegrationService;
    @Autowired
    private MerchantOrderProperties merchantOrderProperties;
    @Autowired
    private MerchantMemberCounterService merchantMemberCounterService;
    private ApplicationContext applicationContext;

    @Override
    public void afterOrderPaySuccess(AfterOrderPaySuccessParam param) {
        this.applicationContext.publishEvent((Object)GoodsOrderPaymentEvent.builder().goodsId(param.getGoodsId()).userId(param.getUserId()).orderNo(param.getOrderNo()).build());
        this.merchantMemberCounterService.addOrderCounter(null, param.getMerchantId(), 1);
    }

    @Override
    public Boolean operatorOrder(MerchantOperatorOrderParam merchantOperatorOrderParam) {
        return this.marketIntegrationService.operatorOrder(merchantOperatorOrderParam.getOrderNo(), merchantOperatorOrderParam.getState()).isSuccess();
    }

    @Override
    public MerchantBuyPromoteDTO createMerchantOrder(MerchantBuyOrderParam param) {
        MerchantBuyPromoteDTO result = new MerchantBuyPromoteDTO();
        if (Objects.equals(param.getUsePromotion(), AppConst.ENABLE)) {
            MerchantOpenVipDTO openVipDTO = this.openMerchantVip(param.getMerchantId(), param.getUserId());
            if (Objects.equals(openVipDTO.getMoney().compareTo(BigDecimal.ZERO), 0)) {
                result.setState(Integer.valueOf(1));
                return result;
            }
            param.setAmount(openVipDTO.getMoney());
            param.setOrderSn(openVipDTO.getOrderNo());
        } else {
            PromoteMoneyDTO promoteMoneyDTO = this.promoteService.getPromoteMoney(param.getUserId(), null);
            param.setAmount(promoteMoneyDTO.getTotalMoney());
            promoteMoneyDTO.setMoney(promoteMoneyDTO.getTotalMoney());
            promoteMoneyDTO.setPromoteMoney(BigDecimal.ZERO);
            MerchantOpenvipOrderEntity openvipOrderEntity = this.addOpenVipInfo(promoteMoneyDTO);
            if (null != openvipOrderEntity) {
                param.setOrderSn(openvipOrderEntity.getOrderNo());
            }
        }
        UserOrderParam orderParam = new UserOrderParam();
        BeanUtils.copyProperties((Object)param, (Object)orderParam);
        orderParam.setPaymentTitle("\u4e07\u4e8b\u901a\u5546\u5bb6\u4f1a\u5458");
        PaymentOrderDTO paymentOrderDTO = this.paymentIntegrationService.orderCreate(orderParam);
        BeanUtils.copyProperties((Object)paymentOrderDTO, (Object)result);
        result.setState(Integer.valueOf(0));
        return result;
    }

    @Override
    public MerchantOperatorOrderDTO verification(MerchantOperatorOrderParam merchantOperatorOrderParam) {
        MerchantOperatorOrderDTO operatorOrderDTO = new MerchantOperatorOrderDTO();
        Integer res = this.marketIntegrationService.verificationOrder(merchantOperatorOrderParam.getVerificationCode(), merchantOperatorOrderParam.getMerchantId());
        operatorOrderDTO.setState(res);
        return operatorOrderDTO;
    }

    @Override
    public Boolean paySuccessCallback(String orderNo) {
        MerchantOpenvipOrderEntity openvipOrderEntity = this.merchantOpenvipOrderMapper.getByOrderNo(orderNo);
        if (null != openvipOrderEntity && Objects.equals(openvipOrderEntity.getStatus(), AppConst.DISALBE)) {
            PromoteMoneyDTO promoteMoneyDTO = new PromoteMoneyDTO();
            promoteMoneyDTO.setMoney(openvipOrderEntity.getPayAmt());
            promoteMoneyDTO.setPromoteMoney(openvipOrderEntity.getDeductionAmt());
            promoteMoneyDTO.setMerchantId(openvipOrderEntity.getMerchantId());
            Boolean flag = this.openVipMoney(promoteMoneyDTO);
            this.merchantOpenvipOrderMapper.updateStatusById(openvipOrderEntity.getId(), AppConst.ENABLE);
            return flag;
        }
        return false;
    }

    @Override
    public PageWarper<MerchantOrderInfoDTO> getPageList(MerchantH5OrderParam merchantH5OrderParam) {
        PageWarper pageWarderList = this.marketIntegrationService.merchantOrderList(merchantH5OrderParam);
        PageWarper resultPage = new PageWarper();
        BeanUtils.copyProperties((Object)pageWarderList, (Object)resultPage);
        resultPage.setList(pageWarderList.getList().stream().map(this::convertToDto).filter(Objects::nonNull).collect(Collectors.toList()));
        return resultPage;
    }

    @Override
    public PageWarper<MerchantManageOrderInfoDTO> getManagePageListOrder(MerchantManageOrderParam manageOrderParam) {
        PageWarper pageWarderList = this.marketIntegrationService.getManagePageListOrder(manageOrderParam);
        PageWarper resultPage = new PageWarper();
        BeanUtils.copyProperties((Object)pageWarderList, (Object)resultPage);
        resultPage.setList(pageWarderList.getList().stream().map(this::convertToManageDto).collect(Collectors.toList()));
        return resultPage;
    }

    @Override
    public MerchantOpenVipDTO openMerchantVip(Long merchantId, Long userId) {
        MerchantOpenVipDTO openVipDTO = new MerchantOpenVipDTO();
        PromoteMoneyDTO promoteMoneyDTO = this.promoteService.getPromoteMoney(userId, null);
        if (Objects.equals(promoteMoneyDTO.getMoney().compareTo(BigDecimal.ZERO), 0)) {
            this.openVipMoney(promoteMoneyDTO);
            openVipDTO.setMoney(BigDecimal.ZERO);
        } else {
            promoteMoneyDTO = this.promoteService.getPromoteMoney(userId, null);
            MerchantOpenvipOrderEntity openvipOrderEntity = this.addOpenVipInfo(promoteMoneyDTO);
            openVipDTO.setMoney(promoteMoneyDTO.getMoney());
            openVipDTO.setOrderNo(openvipOrderEntity.getOrderNo());
        }
        return openVipDTO;
    }

    private Boolean openVipMoney(PromoteMoneyDTO promoteMoneyDTO) {
        MerchantOpenVipParam openVipParam = new MerchantOpenVipParam();
        openVipParam.setPayMoney(String.valueOf(promoteMoneyDTO.getMoney()));
        openVipParam.setId(promoteMoneyDTO.getMerchantId());
        openVipParam.setDeductionMoney(String.valueOf(promoteMoneyDTO.getPromoteMoney()));
        openVipParam.setInterestsType(Integer.valueOf(0));
        openVipParam.setOpenType(Integer.valueOf(0));
        return this.interestsService.openVip(openVipParam, 1);
    }

    private MerchantOpenvipOrderEntity addOpenVipInfo(PromoteMoneyDTO promoteMoneyDTO) {
        MerchantOpenvipOrderEntity openvipOrderEntity = new MerchantOpenvipOrderEntity();
        openvipOrderEntity.setCreateTime(new Date());
        openvipOrderEntity.setMerchantId(promoteMoneyDTO.getMerchantId());
        openvipOrderEntity.setDeductionAmt(promoteMoneyDTO.getPromoteMoney());
        openvipOrderEntity.setPrerogativeType(Integer.valueOf(promoteMoneyDTO.getOpenType().intValue()));
        openvipOrderEntity.setPayAmt(promoteMoneyDTO.getMoney());
        openvipOrderEntity.setStatus(AppConst.DISALBE);
        openvipOrderEntity.setId(this.sequenceCreater.nextLongId());
        openvipOrderEntity.setOrderNo(NidGeneratorUtil.getOrderNo((String)""));
        this.merchantOpenvipOrderMapper.insert(openvipOrderEntity);
        return openvipOrderEntity;
    }

    private MerchantOrderInfoDTO convertToDto(GroupOrderInfoFacadeVO entity) {
        GroupOrderInfoFacadeVO detailByOrderNo = this.marketIntegrationService.getDetailByOrderNo(entity.getOrderSn());
        if (Objects.isNull(detailByOrderNo)) {
            return null;
        }
        MerchantOrderInfoDTO orderInfoDTO = MerchantOrderInfoDTO.builder().goodsId(Long.valueOf(Long.parseLong(entity.getGoodsId()))).goodsImg(entity.getImgUrl()).goodsName(entity.getGoodsName()).orderNo(entity.getOrderSn()).userName(entity.getOwnerUserName()).userPhone(entity.getOwnerUserPhone()).dateTime(entity.getCreateTime()).num(Long.valueOf(entity.getGoodsNum().longValue())).orderMoney(detailByOrderNo.getOriginalPayPrice()).userPayMoney(detailByOrderNo.getRealPayPrice()).coupon(detailByOrderNo.getCouponSavePrice()).couponDesc("\u73b0\u91d1\u7ea2\u5305\u62b5\u6263").build();
        if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.REFUNDING.getStatus())) {
            long leftTime = 0L;
            if (Objects.nonNull(entity.getRefundTime())) {
                leftTime = DateUtils.getDiffSeconed((Date)new Date(), (Date)entity.getRefundTime(), (boolean)true);
                leftTime = (long)this.merchantOrderProperties.getRefundMaxScened().intValue() - leftTime;
                if (leftTime < 0L) {
                    leftTime = 0L;
                }
            } else {
                log.warn("\u8ba2\u5355: {}\u7684\u9000\u6b3e\u65f6\u95f4\u4e3a\u7a7a \u65e0\u6cd5\u8ba1\u7b97\u5269\u4f59\u5904\u7406\u65f6\u95f4", (Object)entity.getOrderStatus());
            }
            orderInfoDTO.setLeftTime(Long.valueOf(leftTime));
        }
        if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.PAY_SUCCESS.getStatus())) {
            orderInfoDTO.setState(Integer.valueOf(0));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.WAIT_PAY.getStatus())) {
            orderInfoDTO.setState(Integer.valueOf(1));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.REFUNDING.getStatus())) {
            orderInfoDTO.setState(Integer.valueOf(2));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.CONSUME_SUCCESS.getStatus()) && Objects.equals(entity.getSubStatus(), 0)) {
            orderInfoDTO.setState(Integer.valueOf(3));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.DISABLE.getStatus())) {
            orderInfoDTO.setState(Integer.valueOf(4));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.CONSUME_SUCCESS.getStatus()) && Objects.equals(entity.getSubStatus(), GroupOrderSubStates.PAY_SUCCESS_BY_REFUND_REFUSE.getStatus())) {
            orderInfoDTO.setState(Integer.valueOf(5));
        } else if (Objects.equals(entity.getOrderStatus(), GroupOrderStates.DISABLE.getStatus()) && (Objects.equals(entity.getSubStatus(), GroupOrderSubStates.DISABLE_BY_MANUAL_REFUND.getStatus()) || Objects.equals(entity.getSubStatus(), GroupOrderSubStates.DISABLE_BY_AUTO_REFUND.getStatus()))) {
            orderInfoDTO.setState(Integer.valueOf(6));
        }
        orderInfoDTO.setCoupon(detailByOrderNo.getCouponSavePrice());
        return orderInfoDTO;
    }

    private MerchantManageOrderInfoDTO convertToManageDto(GroupOrderInfoFacadeVO entity) {
        MerchantManageOrderInfoDTO orderInfoDTO = MerchantManageOrderInfoDTO.builder().goodsName(entity.getGoodsName()).orderNo(entity.getOrderSn()).userName(entity.getOwnerUserName()).userPhone(entity.getOwnerUserPhone()).dateTime(entity.getCreateTime()).orderMoney(entity.getRealPayPrice().add(entity.getCouponSavePrice())).merchantName(entity.getMerchantName()).state(Integer.valueOf(this.getMechantOrderStatus(entity))).payTime(entity.getCreateTime()).num(Integer.valueOf(entity.getGoodsNum())).build();
        return orderInfoDTO;
    }

    private int getMechantOrderStatus(GroupOrderInfoFacadeVO entity) {
        GroupOrderStates orderStates = GroupOrderStates.getByCode((Integer)entity.getOrderStatus());
        switch (orderStates) {
            case WAIT_PAY: {
                return 0;
            }
            case PAY_SUCCESS: {
                return 1;
            }
            case CONSUME_SUCCESS: {
                return 2;
            }
            case REFUNDING: {
                return 3;
            }
            case DISABLE: {
                if (Objects.equals(entity.getSubStatus(), GroupOrderSubStates.DISABLE_BY_MANUAL_REFUND.getStatus()) || Objects.equals(entity.getSubStatus(), GroupOrderSubStates.DISABLE_BY_AUTO_REFUND.getStatus())) {
                    return 5;
                }
                if (!Objects.equals(entity.getSubStatus(), GroupOrderSubStates.DISABLE_BY_TIME_OUT_CANCEL.getStatus())) break;
                return 6;
            }
        }
        return 0;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

