/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.sync.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.MerchantActionRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberCounterMapper;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.service.sync.SyncUserService;
import com.bxm.localnews.user.event.RedundancyActionEvent;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Service;

@Service
public class SyncUserServiceImpl
implements SyncUserService {
    private static final Logger log = LogManager.getLogger(SyncUserServiceImpl.class);
    @Resource
    MerchantActionRecordMapper merchantActionRecordMapper;
    @Resource
    MerchantMemberCounterMapper merchantMemberCounterMapper;
    @Resource
    MerchantMemberFacadeService merchantMemberFacadeService;

    @StreamListener(value="redundanyInput")
    public void handleUserChange(RedundancyActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53d7\u5230\u7528\u6237\u5197\u4f59\u4fe1\u606f\u53d8\u66f4 \uff1a {}", (Object)JSON.toJSONString((Object)event));
        }
        if (Objects.nonNull(event)) {
            this.syncUserInfo(event.getUserId(), event.getHeadImg(), event.getNickName());
        }
    }

    @Override
    public void syncUserInfo(Long userId, String headImg, String nickName) {
        this.merchantActionRecordMapper.updateHeadImgAndNickNameByActor(String.valueOf(userId), headImg, nickName);
        this.merchantActionRecordMapper.updateHeadImgAndNickNameByBelonger(userId, headImg, nickName);
        this.merchantMemberCounterMapper.updateHeadImgAndNickName(userId, headImg, nickName);
        this.merchantMemberFacadeService.updateHeadImgAndNickName(userId, headImg, nickName);
    }
}

