/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.utils;

import com.bxm.localnews.common.constant.TalentLevelEnum;
import com.bxm.localnews.merchant.common.enums.GoodsCommissionTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsRateProperties;
import com.bxm.localnews.merchant.dto.goods.CalculateUserCommissionDTO;
import com.bxm.localnews.merchant.entity.goods.MemberDayGoodsCategoryExtDataDTO;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoodsPriceRelatedUtils {
    private static final Logger log = LoggerFactory.getLogger(GoodsPriceRelatedUtils.class);
    @Autowired
    private MerchantGoodsRateProperties merchantGoodsRate;
    private static MerchantGoodsRateProperties merchantGoodsRateProperties;
    private static final BigDecimal RATE_1;

    @PostConstruct
    public void init() {
        merchantGoodsRateProperties = this.merchantGoodsRate;
    }

    public static BigDecimal getVipPrice(BigDecimal price, Integer vipDiscount) {
        BigDecimal vipPrice = price;
        if (vipDiscount != null && 1 == vipDiscount && (vipPrice = price.multiply(merchantGoodsRateProperties.getVipRebate()).setScale(2, 4)).compareTo(BigDecimal.ZERO) <= 0) {
            vipPrice = RATE_1;
        }
        return vipPrice;
    }

    public static BigDecimal getMemberDayGoodsCommission(Integer userType, boolean groupCommission, MemberDayGoodsCategoryExtDataDTO extDataDTO) {
        if (userType == null || Objects.equals(userType, TalentLevelEnum.ORDINARY_USER.getCode())) {
            return BigDecimal.ZERO;
        }
        if (!groupCommission) {
            if (userType.equals(TalentLevelEnum.BIG_TALENT.getCode())) {
                return extDataDTO.getBigTalentCommission() == null ? BigDecimal.ZERO : extDataDTO.getBigTalentCommission();
            }
            return extDataDTO.getNoBigTalentCommission() == null ? BigDecimal.ZERO : extDataDTO.getNoBigTalentCommission();
        }
        return extDataDTO.getTeamCommission() == null ? BigDecimal.ZERO : extDataDTO.getTeamCommission();
    }

    public static BigDecimal getDiscount(BigDecimal price, Integer vipDiscount, BigDecimal originalPrice, BigDecimal vipPrice) {
        int isVip = vipDiscount == null ? 0 : vipDiscount;
        BigDecimal coPrice = isVip == 1 ? vipPrice : price;
        BigDecimal discount = coPrice.divide(originalPrice, 2, 1).multiply(BigDecimal.TEN);
        if (discount.compareTo(BigDecimal.ZERO) <= 0) {
            discount = RATE_1;
        }
        return discount;
    }

    public static BigDecimal getUserResultCommission(CalculateUserCommissionDTO commissionDTO) {
        BigDecimal commission = BigDecimal.ZERO;
        if (Objects.isNull(commissionDTO.getCommissionType()) || Objects.equals(GoodsCommissionTypeEnum.RATE.getCode(), commissionDTO.getCommissionType())) {
            commission = commissionDTO.getPrice().multiply(new BigDecimal(commissionDTO.getCommissionRate())).multiply(RATE_1).setScale(2, 4);
        } else if (Objects.equals(GoodsCommissionTypeEnum.AMOUNT.getCode(), commissionDTO.getCommissionType())) {
            commission = commissionDTO.getCommissionCount().setScale(2, 4);
        }
        return GoodsPriceRelatedUtils.getGoodsGroupBuyCommission(commission, commissionDTO.getTalentLevel(), commissionDTO.getGroupCommission());
    }

    public static BigDecimal getTotalCommission(BigDecimal price, Integer commissionRate) {
        return price.multiply(new BigDecimal(commissionRate)).multiply(RATE_1).setScale(2, 4);
    }

    private static BigDecimal getGoodsGroupBuyCommission(BigDecimal commission, Integer userType, boolean teamCommission) {
        BigDecimal resultCommission = BigDecimal.ZERO;
        if (!teamCommission) {
            if (userType == null || userType.equals(TalentLevelEnum.ORDINARY_USER.getCode())) {
                return resultCommission;
            }
            resultCommission = userType.equals(TalentLevelEnum.BIG_TALENT.getCode()) ? commission.multiply(merchantGoodsRateProperties.getBigTalentRebate()).setScale(2, 4) : (userType.equals(TalentLevelEnum.MIDDLE_TALENT.getCode()) ? commission.multiply(merchantGoodsRateProperties.getMidTalentRebate()).setScale(2, 4) : commission.multiply(merchantGoodsRateProperties.getSmallTalentRebate()).setScale(2, 4));
        } else {
            resultCommission = commission.multiply(merchantGoodsRateProperties.getTeamCommissionRebate()).setScale(2, 4);
        }
        return resultCommission;
    }

    static {
        RATE_1 = new BigDecimal("0.01");
    }
}

