package com.bxm.localnews.mq.common.enums;

import lombok.Getter;

@Getter
public enum WxMpTemplateEnum {

    /**
     * 用户付款成功
     * {{first.DATA}}           购买成功，点详情查看订单哦
     * {{keyword1.DATA}}        商品名称（一行显示，多余...）
     * {{keyword2.DATA}}        订单编号
     * {{keyword3.DATA}}        订单金额
     * {{keyword4.DATA}}        付款时间）2020.20.20 20：00
     * {{remark.DATA}}          购物愉快，请及时到店消费哦~
     */
    USER_PAY_SUCCESS,

    /**
     * 普通用户发展成达人
     * {{first.DATA}}        达人注册成功
     * {{keyword1.DATA}}     注册时间
     * {{keyword2.DATA}}     小达人
     * {{remark.DATA}}      您已获得自购省钱分享赚钱特权哦~
     */
    REGISTER_TALENT,

    /**
     * 达人邀请注册成功
     * {{first.DATA}}       发展团队成功，当前团队人数X人
     * {{keyword1.DATA}}    被邀请人注册填写的姓名
     * {{keyword2.DATA}}    被邀请人注册填写的手机号
     * {{keyword3.DATA}}    注册时间
     * {{remark.DATA}}      您当前是小/中/大达人，团队成员越多收益越多哦~
     */
    TALENT_INVITE_REGISTER_SUCCESS,

    /**
     * 佣金发送成功
     * {{first.DATA}}
     * {{keyword1.DATA}}
     * {{keyword2.DATA}}
     * {{keyword3.DATA}}
     * {{remark.DATA}}
     */
    COMMISSION_GIVE_OUT,

    /**
     * 夺宝开奖
     * {{first.DATA}}
     * {{keyword1.DATA}}
     * {{keyword2.DATA}}
     * {{keyword3.DATA}}
     * {{remark.DATA}}
     */
    LOTTERY,
    ;
}
