package com.bxm.localnews.mq.common.param;

import com.bxm.localnews.mq.common.enums.WxMpTemplateEnum;
import com.google.common.collect.Maps;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import java.util.LinkedHashMap;

/**
 * 微信公众号消息推送参数
 */
@ToString
@Data
@Builder
public class WechatMpPushMessage {

    @Tolerate
    public WechatMpPushMessage() {
    }

    private int varIndex;

    /**
     * 推送模板
     */
    private WxMpTemplateEnum wxMpTemplate;

    /**
     * 推送目标用户ID
     */
    private Long userId;

    /**
     * 推送目标用户oid
     */
    private String oid;

    /**
     * 模板消息内容(需保持顺序)
     */
    private LinkedHashMap<String, String> valueMap;

    /**
     * 推送模板id
     */
    private String templateId;

    /**
     * 模板跳转链接（海外帐号没有跳转能力）
     */
    private String url;

    /**
     * 非常规的变量设置
     *
     * @param key   变量键值（eg:first）
     * @param value 变量值
     * @return 当前对象
     */
    public WechatMpPushMessage addValue(String key, String value) {
        if (valueMap == null) {
            valueMap = Maps.newLinkedHashMap();
        }
        valueMap.put(key, value);
        return this;
    }

    /**
     * 公众号中的变量设置根据<b>调用的顺序</b>转换为keyword+序列
     *
     * @param value 变量值
     * @return 当前对象
     */
    public WechatMpPushMessage addVar(String value) {
        if (valueMap == null) {
            valueMap = Maps.newLinkedHashMap();
        }

        valueMap.put("keyword" + (++varIndex), value);

        return this;
    }
}
