package com.bxm.localnews.mq.consume.config;

import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.bxm.localnews.mq.consume.listener.PushMessageListener;
import com.bxm.localnews.mq.consume.listener.SmsMessageListener;
import com.bxm.localnews.mq.consume.listener.DefaultMessageListener;
import com.bxm.localnews.mq.common.config.AliyunMqProperties;
import com.google.common.collect.Maps;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Properties;

/**
 * 阿里云消息队列配置
 * @author liujia 2018/7/27 14:25
 */
@Component
@Configuration
@ConditionalOnProperty(prefix = "aliyun.mq", value = "access-key")
@EnableConfigurationProperties(AliyunMqProperties.class)
public class AliyunMqConsumeConfiguration {

    @Resource
    private AliyunMqProperties aliyunMqProperties;

    @Resource
    private DefaultMessageListener defaultMessageListener;

    @Resource
    private SmsMessageListener smsMessageListener;

    @Resource
    private PushMessageListener pushMessageListener;

    /**
     * 业务消息队列消费者
     */
    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public ConsumerBean consumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();

        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        consumerBean.setProperties(properties);

        Map<Subscription, MessageListener> subscriptionTable = Maps.newHashMap();

        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getTopic());
        subscription.setExpression("*");

        defaultMessageListener.init();
        subscriptionTable.put(subscription, this.defaultMessageListener);

        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

    /**
     * 短信消费者
     * @return
     */
    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public ConsumerBean smsConsumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();

        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getSmsConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        consumerBean.setProperties(properties);

        Map<Subscription, MessageListener> subscriptionTable = Maps.newHashMap();

        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getSmsTopic());
        subscription.setExpression("*");

        subscriptionTable.put(subscription, this.smsMessageListener);

        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

    /**
     * 推送消息消费者
     * @return
     */
    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public ConsumerBean pushConsumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();

        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getPushConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        consumerBean.setProperties(properties);

        Map<Subscription, MessageListener> subscriptionTable = Maps.newHashMap();

        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getPushTopic());
        subscription.setExpression("*");

        subscriptionTable.put(subscription, this.pushMessageListener);

        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

}
