package com.bxm.localnews.mq.consume.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 短信发送配置
 * @author liujia 2018/7/26 16:37
 */
@Component
@ConfigurationProperties("message.config")
public class MessageProperties {

    /**
     * 示远短信发送请求路径
     */
    private String shiyuanUrl;

    /**
     * 示远短信账号
     */
    private String shiyuanAccount;

    /**
     * 示远短信密码
     */
    private String shiyuanPwd;

    /**
     * 是否启用发送验证码
     */
    private Boolean enableSms;

    public String getShiyuanAccount() {
        return shiyuanAccount;
    }

    public void setShiyuanAccount(String shiyuanAccount) {
        this.shiyuanAccount = shiyuanAccount;
    }

    public String getShiyuanPwd() {
        return shiyuanPwd;
    }

    public void setShiyuanPwd(String shiyuanPwd) {
        this.shiyuanPwd = shiyuanPwd;
    }

    public Boolean getEnableSms() {
        return enableSms;
    }

    public void setEnableSms(Boolean enableSms) {
        this.enableSms = enableSms;
    }

    public String getShiyuanUrl() {
        return shiyuanUrl;
    }

    public void setShiyuanUrl(String shiyuanUrl) {
        this.shiyuanUrl = shiyuanUrl;
    }

}
