package com.bxm.localnews.mq.consume.listener;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.consume.consumer.TagMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;

/**
 * 定义一个默认的消息监听服务，根据消息的tag进行消息分发（资源有限-_-||）
 * @author liujia 2018/8/11 23:18
 */
@Component
public class DefaultMessageListener implements MessageListener, ApplicationContextAware {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageListener.class);

    private ApplicationContext applicationContext;

    private Collection<TagMessageConsumer> consumers;

    private BlockingQueue queue;

    @Override
    public Action consume(Message message, ConsumeContext context) {
        Action result = Action.ReconsumeLater;
        String tag = message.getTag();

        LOGGER.debug("tag:[{}],consume message:[{}]", tag, message);

        for (TagMessageConsumer consumer : this.consumers) {
            if (consumer.support(tag)) {

                LOGGER.debug("consumer:[{}][{}]", consumer, tag);

                result = consumer.consume(message, context);

                if (Action.CommitMessage.equals(result)) {
                    return result;
                }
            }
        }
        return result;
    }

    /**
     * 手动添加消费者到监听器
     * @param consumer
     */
    public void addConsume(TagMessageConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        Map<String, TagMessageConsumer> consumer = this.applicationContext.getBeansOfType(TagMessageConsumer.class);
        if (consumer.size() > 0) {
            this.consumers = consumer.values().stream().sorted(Comparator.comparingInt(TagMessageConsumer::order)).collect(Collectors.toList());
        } else {
            LOGGER.warn("没有发现任何注册的消费者");
        }
    }

}
