package com.bxm.localnews.mq.consume.listener;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.consume.service.GeTuiService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * Created by Arei on 2018/10/12.
 * 推送消息处理监听器
 *
 * @author Arei
 */
@Component
public class PushMessageListener implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(PushMessageListener.class);
    @Resource
    private GeTuiService geTuiService;
    @Resource
    private ObjectMapper objectMapper;

    @Override
    public Action consume(Message message, ConsumeContext consumeContext) {
        try {
            String msg = new String(message.getBody());
            PushMessage pushMessage = objectMapper.readValue(msg, PushMessage.class);
            Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(message.getTag());
            if (tagEnumOptional.isPresent()) {
                switch (tagEnumOptional.get()) {
                    case PUSH:
                        geTuiService.push(pushMessage);
                        return Action.CommitMessage;
                    case PUSH_ALL:
                        geTuiService.pushMsgToAll(pushMessage);
                        return Action.CommitMessage;
                    case PUSH_GROUP:
                        geTuiService.pushGroupMsg(pushMessage);
                        return Action.CommitMessage;
                    default:
                        logger.error("未做处理的tag");
                        return Action.ReconsumeLater;
                }
            }
            logger.error("非法的tag");
            return Action.ReconsumeLater;


        } catch (Exception e) {
            //消费失败
            logger.error("PUSH-MSG-CONSUME-ERR", e);
            return Action.ReconsumeLater;
        }
    }
}
