package com.bxm.localnews.mq.consume.service;

import com.bxm.localnews.mq.common.model.dto.PushMessage;

/**
 * Created by Arei on 2018/10/15.
 * 个推消息推送方法实现
 *
 * @author Arei
 */
public interface GeTuiService {
    /**
     * 单挑消息推送
     *
     * @param pushMessage
     */
    void push(PushMessage pushMessage);

    /**
     * 推送给所有用户
     *
     * @param pushMessage
     */
    void pushMsgToAll(PushMessage pushMessage);

    /**
     * 推送多个用户
     * 已包含userid去重
     * 策略：id列表小于50个走单推，大于等于50走群推
     *
     * @param pushMessage 消息
     */
    void pushGroupMsg(PushMessage pushMessage);
}
