package com.bxm.localnews.msg.domain;

import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.vo.Tuple;
import com.bxm.localnews.msg.vo.UserMessageBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MessageMapper {

    int insertSelective(UserMessageBean record);

    List<UserMessageBean> listMessage(MessageListParam messageListParam);

    int countMessage(@Param("userId") Long userId);

    int updateMessageByType(MessageListParam messageListParam);

    /**
     * 获取各个类型未读消息的数量
     *
     * @param userId 用户ID
     * @return 未读消息的类型和数量
     */
    List<Tuple> getUnreadMap(Long userId);

    /**
     * 获取用户的各种类型的最后一条消息
     *
     * @param userId 用户ID
     * @return 最后一条消息列表
     */
    List<UserMessageBean> getLastMsg(@Param("userId") Long userId, @Param("lastIdList") List<Long> lastIdList);

    /**
     * 获取用户的各种消息的最后ID
     *
     * @param userId 用户ID
     * @return 最后一条消息
     */
    List<UserMessageBean> getLastMsgType(Long userId);
}
