package com.bxm.localnews.msg.domain;

import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MsgGroupPushMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MsgGroupPushBean record);

    MsgGroupPushBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MsgGroupPushBean record);

    /**
     * 增加群推消息的触达用户总数
     *
     * @param msgId     消息ID
     * @param userTotal 触达用户总数
     * @return 更新结果
     */
    int addUserTotal(@Param("msgId") Long msgId, @Param("userTotal") Integer userTotal);

    /**
     * 分页查询群推消息
     *
     * @param param 分页参数
     * @return 查询结果
     */
    List<MsgGroupPushBean> selectByPage(PushMessageParam param);
}