package com.bxm.localnews.msg.domain;

import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MsgUserTokenMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MsgUserTokenBean record);

    MsgUserTokenBean selectByPrimaryKey(Long id);

    /**
     * 查询用户所有类型token
     *
     * @param userId 用户ID
     * @return 用户token列表
     */
    List<MsgUserTokenBean> queryUserToken(Long userId);

    /**
     * 移除用户对应的token值
     *
     * @param userId    用户ID
     * @param tokenType token类型
     * @return 影响行数
     */
    int removeToken(@Param("userId") Long userId, @Param("tokenType") Byte tokenType);
}