package com.bxm.localnews.msg.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

@Slf4j
@RequestMapping("/facade/message/mock")
@Primary
@Component
public class PushFacadeServiceMock implements PushFacadeService {
    @Override
    public void pushMsg(PushMessage message) {
        log.info("触发消息推送：{}", JSON.toJSONString(message));
    }
}
