package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.dingtalk.DingtalkPushService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "5-92 [内部]钉钉消息推送")
@RestController
@RequestMapping
public class DingtalkFacadeController extends BaseController {

    private final DingtalkPushService dingtalkPushService;

    @Autowired
    public DingtalkFacadeController(DingtalkPushService dingtalkPushService) {
        this.dingtalkPushService = dingtalkPushService;
    }

    @ApiOperation(value = "5-92-1 [已废弃]推送钉钉消息到新闻监控群")
    @ApiImplicitParam(name = "content", value = "推送内容")
    @PostMapping("dingtalk/news")
    @Deprecated
    public void pushNewsGroup(@RequestBody String content) {
        dingtalkPushService.pushNews(content);
    }

    @ApiOperation(value = "5-92-2 [已废弃]推送钉钉消息到即时通讯监控群")
    @ApiImplicitParam(name = "content", value = "推送内容")
    @PostMapping("facade/message/dingtalk/im")
    @Deprecated
    public void pushIMGroup(@RequestBody String content) {
        dingtalkPushService.pushIM(content);
    }

    @ApiOperation(value = "5-92-3 通用钉钉消息推送")
    @PostMapping("facade/message/dingtalk")
    public void pushDingtalk(@RequestBody DingtalkMessage message) {
        dingtalkPushService.push(message);
    }
}
