package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.service.UserMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Api(tags = "5-90 用户消息列表", description = "获取用户的消息")
@RestController
@RequestMapping("/facade/msg")
public class MessageFacadeController {

    private final UserMessageService userMessageService;

    @Autowired
    public MessageFacadeController(UserMessageService userMessageService) {
        this.userMessageService = userMessageService;
    }

    @ApiOperation(value = "5-90-1 计算用户消息的总数，在个人中心显示")
    @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    @RequestMapping(value = "/number", method = RequestMethod.GET)
    @Deprecated
    public ResponseEntity<Integer> countTotalMsg(@RequestParam("userId") Long userId) {
        /*
         * V3.4.0 该接口没有业务场景调用，去除
         */
        return ResponseEntity.ok(0);
    }

    @ApiOperation(value = "5-90-2 添加用户消息")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResponseEntity<Boolean> addMsg(@RequestBody PushMessage pushMessage, @RequestParam("userId") Long userId) {
        userMessageService.addMessage(pushMessage, userId);
        return ResponseEntity.ok(true);
    }

    @ApiOperation(value = "5-90-3 批量添加用户未读消息")
    @PostMapping("batch/unread")
    public void batchAddUnReadMsg(@RequestBody List<PushMessage> messages) {
        for (PushMessage message : messages) {
            userMessageService.addUnreadMsg(message, message.getPushReceiveScope().getUserId());
        }
    }

    @ApiOperation(value = "5-90-4 设置用户某类消息为已读状态")
    @PostMapping("read")
    public void setRead(@RequestParam("userId") Long userId, @RequestParam("msgType") String msgType) {
        userMessageService.updateMessageByType(userId, msgType);
    }

    @ApiOperation(value = "5-90-5 添加用户的最后未读消息")
    @PostMapping("batch/last")
    public void batchAddLastMsg(@RequestBody List<PushMessage> messages) {
        for (PushMessage message : messages) {
            userMessageService.addLastMsg(message);
        }
    }

    @ApiOperation(value = "5-90-6 根据类别获取获取未读的消息数")
    @GetMapping("unread-num")
    public ResponseEntity<Map<String, Long>> getUnReadMessageNum(@RequestParam(value = "userId") Long userId, @RequestParam(value = "messageType") String messageType) {
        return ResponseEntity.ok(userMessageService.getUnReadNum(userId, messageType));
    }
}
