package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.param.PushMsgBuildParam;
import com.bxm.localnews.msg.service.PushMsgSupplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "5-99 客户端消息推送")
@RestController
public class PushMsgSupplyController {
    @Resource
    private PushMsgSupplyService pushMsgSupplyService;

    @ApiOperation(value = "5-99-1 [废弃]推送消息到客户端",
            notes = "路径不规范，不再推荐使用，使用5-99-5代替")
    @PostMapping("/push")
    @Deprecated
    public void pushMsg(@RequestBody PushMessage message) {
        pushMsgSupplyService.pushMsg(message);
    }

    /**
     * @deprecated 3.0.0迁移至内部调度
     */
    @ApiOperation(value = "5-99-2 [废弃]推送互动消息")
    @PostMapping("/push/interaction")
    @Deprecated
    public void pushInteractionMessage() {
        pushMsgSupplyService.pushInteraction();
    }

    @ApiOperation(value = "5-99-3 [废弃]定时推送消息", notes = "原本在运营后台服务中调用，现迁移到消息服务内部提供服务")
    @PostMapping("/push/timingPush")
    @Deprecated
    public void timingPush(@RequestBody PushMsgBuildParam param) {
        pushMsgSupplyService.timingPush(param);
    }

    @ApiOperation(value = "5-99-4 [废弃]移除定时推送消息", notes = "原本在运营后台服务中调用，现迁移到消息服务内部提供服务")
    @PostMapping("/push/removeTimingPush")
    public void removeTimingPush(@RequestParam("messageId") Long messageId) {
        pushMsgSupplyService.removeTimingPush(messageId);
    }

    @ApiOperation(value = "5-99-5 执行消息推送")
    @PostMapping("/facade/message/push")
    public void push(@RequestBody PushMessage message) {
        pushMsgSupplyService.pushMsg(message);
    }
}
