package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.msg.service.SmsSupplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-3 短信发送接口")
@RestController
@RequestMapping("/sms")
public class SmsSupplyController {
    @Resource
    private SmsSupplyService smsSupplyService;

    @ApiOperation(value = "1-3-1 发送短信模板消息")
    @PostMapping("/tml")
    public SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        String phoneNo = smsSupplyDTO.getPhoneNo();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String ip = smsSupplyDTO.getIp();
        String[] params = smsSupplyDTO.getParams();
        return smsSupplyService.sendSmsByTemplate(phoneNo, smsTemplate, ip, params);
    }

    @ApiOperation(value = "1-3-2 短信模板消息群发")
    @PostMapping("/group/tml")
    public void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        List<String> phoneNos = smsSupplyDTO.getPhoneNos();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String[] params = smsSupplyDTO.getParams();
        smsSupplyService.sendGroupSmsByTemplate(phoneNos, smsTemplate, params);
    }

    @ApiOperation(value = "1-3-3 发送自定义短信")
    @PostMapping("/custom")
    public SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return smsSupplyService.sendSmsByCustomize(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getContent());
    }

    @ApiOperation(value = "1-3-4 自定义短信群发")
    @PostMapping("/group/custom")
    public void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        smsSupplyService.sendGroupSmsByCustomize(smsSupplyDTO.getPhoneNos(), smsSupplyDTO.getContent());
    }

    @ApiOperation(value = "1-3-5 发送验证码短信模板")
    @PostMapping("/tml/vcode")
    public SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return smsSupplyService.sendSmsByVCodeTemplate(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getSmsTemplateEnum(), smsSupplyDTO.getIp());
    }

    @ApiOperation(value = "1-3-6 验证短信验证码")
    @GetMapping("/verify")
    public Boolean verifySmsCode(@RequestParam("phoneNo") String phoneNo,
                                 @RequestParam("code") String code,
                                 @RequestParam("smsTemplate") SmsTemplateEnum smsTemplate) {
        return smsSupplyService.verifySmsCode(phoneNo, code, smsTemplate);
    }

    @ApiOperation(value = "1-3-7 验证指定类型的验证码")
    @GetMapping("/verify/type")
    public Boolean verifySmsCodeByType(@RequestParam("type") Byte type,
                                       @RequestParam("phoneNo") String phoneNo,
                                       @RequestParam("code") String code) {
        return smsSupplyService.verifySmsCodeByType(type, phoneNo, code);
    }
}
