package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.event.UserEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户事件定义
 */
@Api(tags = "5-94 [内部]用户事件定义")
@RestController
@RequestMapping("/facade/user/event")
public class UserEventController {

    private final UserEventService userEventService;

    @Autowired
    public UserEventController(UserEventService userEventService) {
        this.userEventService = userEventService;
    }

    @ApiOperation(value = "5-94-1 添加用户事件，扩展信息中必须包含userId")
    @PostMapping("add")
    public void add(@RequestBody PushPayloadInfo payloadInfo) {
        userEventService.add(payloadInfo);
    }
}
