package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.service.UserTokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "5-91 [内部]用户token内部接口", description = "用户推送相关的token上报")
@RestController
@RequestMapping("/facade/msg/user/token")
public class UserTokenFacadeController {

    private final UserTokenService userTokenService;

    @Autowired
    public UserTokenFacadeController(UserTokenService userTokenService) {
        this.userTokenService = userTokenService;
    }

    @ApiOperation(value = "5-91 新增用户token")
    @PostMapping("add")
    public void addToken(@RequestBody UserTokenParam param) {
        userTokenService.addToken(param);
    }
}
