package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.UserFacadeService;
import com.bxm.localnews.msg.param.UserSearchPageParam;
import com.bxm.localnews.msg.vo.UserInfoBean;
import com.bxm.newidea.component.vo.PageWarper;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFacadeService> {

    @Override
    public UserFacadeService create(Throwable throwable) {
        return new UserFacadeService() {
            @Override
            public ResponseEntity<UserInfoBean> getUserInfo(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<PageWarper<Long>> getUserByPage(UserSearchPageParam param) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
