package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.dto.AdvertDTO;
import com.bxm.localnews.msg.facade.AdvertFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author zhaoyadong 2019/4/9 10:43
 * @desc
 */
@Service
public class AdvertIntegrationService {

    private final AdvertFeignService advertFeignService;

    @Autowired
    public AdvertIntegrationService(AdvertFeignService advertFeignService) {
        this.advertFeignService = advertFeignService;
    }

    public List<AdvertDTO> getAdvertByType(String type, String areaCode, Long userId) {
        List<AdvertDTO> advertDTOS = advertFeignService.getAdvertsByType(type, areaCode, userId).getBody();
        Objects.requireNonNull(advertDTOS).forEach(advertDTO -> advertDTO.setImgUrl(advertDTO.getIconUrl()));
        return advertDTOS;
    }
}
