/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.manage.controller;

import com.bxm.localnews.msg.dto.AdminPushMessageDTO;
import com.bxm.localnews.msg.dto.PushMessageStatistical;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.service.AdminPushMessageService;
import com.bxm.localnews.msg.vo.AdminPushMessage;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-27 \u6d88\u606f\u63a8\u9001\u76f8\u5173\u63a5\u53e3"}, description="\u6d88\u606f\u7fa4\u4f53\u63a8\u9001")
@RestController
@RequestMapping(value={"/api/admin/push/message"})
public class AdminPushMessageController
extends BaseController {
    private AdminPushMessageService adminPushMessageService;

    @Autowired
    public AdminPushMessageController(AdminPushMessageService adminPushMessageService) {
        this.adminPushMessageService = adminPushMessageService;
    }

    @ApiOperation(value="1-27-1 \u83b7\u53d6\u6d88\u606f\u8bb0\u5f55\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u6d88\u606f\u6570\u636e")
    @GetMapping(value={"/list"})
    public ResponseJson<PageWarper<AdminPushMessageDTO>> getPushMessageList(PushMessageParam pushMessageParam) {
        return ResponseJson.ok((Object)this.adminPushMessageService.queryPushMessageList(pushMessageParam));
    }

    @ApiOperation(value="1-27-3 \u83b7\u53d6\u63a8\u9001\u6d88\u606f\u8be6\u60c5", notes="\u7528\u4e8e\u4fe1\u606f\u7f16\u8f91")
    @ApiImplicitParam(name="id", value="\u6d3b\u52a8id", required=true)
    @GetMapping(value={"/getPushMessageDetail"})
    public ResponseJson<AdminPushMessage> getActivityDetail(Long id) {
        return ResponseJson.ok((Object)this.adminPushMessageService.getDetail(id));
    }

    @ApiOperation(value="1-27-4 \u6d88\u606f\u4fee\u6539\u72b6\u6001(\u53d6\u6d88\u63a8\u9001)", notes="\u53d6\u6d88\u63a8\u9001\uff0c\u7ec8\u6b62\u6b63\u5728\u8fdb\u884c\u7684\u63a8\u9001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/updatePushMessage"})
    public ResponseJson updatePushMessageStatusById(Long id, Byte status) {
        return ResponseJson.build((Message)this.adminPushMessageService.updateStatusPushMessage(id, status));
    }

    @ApiOperation(value="1-27-5 \u65b0\u589e\u6216\u7f16\u8f91\u6d88\u606f", notes="")
    @PostMapping(value={"/saveOrUpdatePushMessage"})
    public ResponseJson addPushMessageDetail(AdminPushMessage adminPushMessage) {
        if (adminPushMessage.getId() == null) {
            // empty if block
        }
        Message message = this.adminPushMessageService.saveOrUpdatePushMessage(adminPushMessage);
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="1-27-6 \u5bf9\u5e94\u6d88\u606f\u7684\u7edf\u8ba1\u4fe1\u606f", notes="\u7edf\u8ba1\u6d88\u606f\u7684\u63a8\u9001\u7ed3\u679c")
    @ApiImplicitParam(name="messageId", value="\u6d88\u606fid", required=true)
    @GetMapping(value={"/statistics"})
    public ResponseJson<Collection<PushMessageStatistical>> statisticsMessage(Long messageId) {
        return ResponseJson.ok((Object)this.adminPushMessageService.getStatistical(messageId));
    }

    @ApiOperation(value="1-27-7 \u6d88\u606f\u63a8\u9001\u6d4b\u8bd5", notes="\u7fa4\u53d1\u6d88\u606f\u524d\u8fdb\u884c\u63a8\u9001\u6d4b\u8bd5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @PostMapping(value={"/test"})
    public ResponseJson testPushMessage(Long id, Long userId) {
        return ResponseJson.ok((Object)this.adminPushMessageService.testPushMessage(id, userId));
    }

    @ApiOperation(value="1-27-8 \u6d88\u606f\u63a8\u9001", notes="\u786e\u5b9a\u8fdb\u884c\u63a8\u9001\u52a8\u4f5c\uff0c\u4e8c\u6b21\u786e\u8ba4\u8fc7\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true)})
    @PostMapping(value={"/immediate"})
    public ResponseJson immediatelyPushMessage(Long id) {
        return ResponseJson.ok((Object)this.adminPushMessageService.immediatelyPushMessage(id));
    }

    @ApiOperation(value="1-27-9 \u6d88\u606f\u6279\u91cf\u7528\u6237\u63a8\u9001\u6d4b\u8bd5", notes="\u6d4b\u8bd5\u591a\u4e2a\u7528\u6237\u63a8\u9001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d88\u606fid", required=true), @ApiImplicitParam(name="userIds", value="\u7528\u6237id\u7ec4, \u4ee5','\u5206\u9694", required=true)})
    @PostMapping(value={"/batch/test"})
    public ResponseJson batchTestPushMessage(Long id, String userIds) {
        return ResponseJson.ok((Object)this.adminPushMessageService.testPushMessage(id, userIds));
    }
}

