package com.bxm.localnews.msg.dto;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "消息中心类型列表")
@Data
public class MessageTypeDTO {

    @ApiModelProperty("广告列表")
    private List<AdvertDTO> advertDTOS = Lists.newArrayList();

    @ApiModelProperty("消息类型列表")
    private List<MessageType> messageTypes = Lists.newArrayList();

    @ApiModelProperty("点赞消息类型")
    private MessageType likeType;

    @ApiModelProperty("新增粉丝消息类型")
    private MessageType followType;

    @ApiModelProperty("评论消息类型")
    private MessageType commentType;

}
