package com.bxm.localnews.msg.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "消息推送记录")
@Data
public class PushMessageParam extends PageParam {

    @ApiModelProperty(value = "推送标题")
    private String title;

    @ApiModelProperty(value = "推送状态（0:待确认、1:待推送、2：已推送）")
    private Byte status;

    @ApiModelProperty(value = "推送目标：1、用户，2：区域")
    private Byte pushTarget;

    @ApiModelProperty(value = "创建人（运营账号id）")
    private Long createUserid;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "选择区域")
    private String areaCode;

    @ApiModelProperty(value = "当前操作用户的ID", hidden = true)
    private Long currentUserId;
}
