/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.UUIDUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.server.Sender;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VivoPushPlatform
extends AbstractPushPlatform {
    private static final Logger log = LoggerFactory.getLogger(VivoPushPlatform.class);
    private Sender sender;
    private AtomicBoolean init = new AtomicBoolean(false);
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private SequenceCreater sequenceCreater;
    private static final Long DEFAULT_EXPIRED_SECONDS = 7200L;
    private static final int MAX_SKIP_CONTENT_LEN = 1024;
    private static final String LOCK_RESOURCE_KEY = "vivoToken";
    private static final int SUCCESS_CODE = 0;
    private static final Integer ALIAS_EXPIRED = 10307;
    private Cache<String, String> tokenCache;
    private String tokenCacheKey = "token";

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        if (null == this.tokenCache || this.tokenCache.getIfPresent((Object)this.tokenCacheKey) == null) {
            this.logger.info("token\u521d\u59cb\u5316\u6216\u5df2\u8fc7\u671f\uff0c\u5c1d\u8bd5\u91cd\u65b0\u6784\u5efa");
            this.initSender();
            this.refreshToken(3);
        }
        Message.Builder messageBuilder = this.getBuilder(message);
        messageBuilder.regId(userToken.getToken());
        try {
            Result result = this.sender.sendSingle(messageBuilder.build());
            if (0 == result.getResult()) {
                callback.apply(message, userToken, Response.success());
            } else if (ALIAS_EXPIRED.intValue() == result.getResult()) {
                callback.apply(message, userToken, Response.expire(result.getDesc()));
            } else {
                callback.apply(message, userToken, Response.fail(result.getDesc()));
            }
        }
        catch (IllegalArgumentException e) {
            if (StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"ParameterError: 10302")) {
                callback.apply(message, userToken, Response.expire(e.getMessage()));
            } else {
                callback.apply(message, userToken, Response.fail(e.getMessage()));
            }
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            callback.apply(message, userToken, Response.fail(e.getMessage()));
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Message.Builder getBuilder(PushMessage pushMessage) {
        return new Message.Builder().title(this.subString(pushMessage.getTitle(), 40)).content(this.subString(pushMessage.getTitle(), 50)).timeToLive(this.convertLiveSeconds(pushMessage)).notifyType(this.convertNotifyType(pushMessage)).networkType(-1).requestId(this.sequenceCreater.nextStringId()).skipType(4).skipContent(this.buildSkipContent(pushMessage));
    }

    private String subString(String content, int expectLength) {
        int length = this.caculateCharSize(content);
        if (length > expectLength) {
            return StringUtils.substring((String)content, (int)0, (int)(expectLength / 2));
        }
        return content;
    }

    private int caculateCharSize(String str) {
        if (str == null) {
            return 0;
        }
        int chineseCharSize = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!this.isChinese(str.charAt(i))) continue;
            ++chineseCharSize;
        }
        return str.length() + chineseCharSize;
    }

    private boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D) {
            return true;
        }
        if (ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private String buildSkipContent(PushMessage pushMessage) {
        PushPayloadInfo payloadInfo = pushMessage.getPayloadInfo();
        payloadInfo.setTitle(null);
        payloadInfo.setContent(null);
        String skipContent = payloadInfo.toJsonString();
        if (StringUtils.length((CharSequence)skipContent) > 1024) {
            log.warn("\u4f20\u8f93\u5185\u5bb9\u8d85\u8fc71024\u4e2a\u5b57\u7b26\uff0c\u8fdb\u884c\u4e86\u622a\u65ad\uff0c\u4fdd\u8bc1\u80fd\u6b63\u5e38\u4f20\u8f93.\u539f\u59cb\u5185\u5bb9\uff1a{}", (Object)skipContent);
            JSONObject jsonObj = JSON.parseObject((String)skipContent);
            jsonObj.remove((Object)"createTime");
            jsonObj.remove((Object)"hasDetail");
            jsonObj.remove((Object)"sound");
            jsonObj.remove((Object)"title");
            jsonObj.remove((Object)"content");
            skipContent = jsonObj.toJSONString();
            if (StringUtils.length((CharSequence)skipContent) > 1024) {
                log.error("\u63a8\u9001\u5185\u5bb9\u4ecd\u7136\u8d85\u957f\uff0c\u5220\u9664\u534f\u8bae\u5b57\u6bb5\u548c\u989d\u5916\u53c2\u6570\uff0c\u88c1\u526a\u540e\u7684\u7ed3\u679c\uff1a{}", (Object)skipContent);
                jsonObj.remove((Object)"protocol");
                jsonObj.remove((Object)"extend");
                skipContent = jsonObj.toJSONString();
            }
        }
        return skipContent;
    }

    private int convertLiveSeconds(PushMessage pushMessage) {
        if (null != pushMessage.getPeriodTime() && pushMessage.getPeriodTime() > 0) {
            return pushMessage.getPeriodTime() * 3600;
        }
        return 604800;
    }

    private int convertNotifyType(PushMessage message) {
        if (!message.isMute() && message.isShock()) {
            return 4;
        }
        if (message.isShock()) {
            return 3;
        }
        if (!message.isMute()) {
            return 2;
        }
        return 1;
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.VIVO;
    }

    private void initLocalCache(String token, long expredMillseconds) {
        this.logger.info("\u521d\u59cb\u5316\u672c\u5730\u7f13\u5b58\uff0c{}\u5c06\u5728{}\u540e\u8fc7\u671f", (Object)token, (Object)expredMillseconds);
        Cache swapCache = CacheBuilder.newBuilder().initialCapacity(1).expireAfterWrite(expredMillseconds, TimeUnit.MILLISECONDS).build();
        swapCache.put((Object)this.tokenCacheKey, (Object)token);
        this.tokenCache = swapCache;
    }

    private void initSender() {
        if (this.init.compareAndSet(false, true)) {
            try {
                this.sender = new Sender(this.appPushProperties.getVivoAppSecret());
                this.sender.initPool(20, 10);
                log.info("\u521d\u59cb\u5316vivo sender");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refreshToken(int maxAttempts) {
        if (maxAttempts <= 0) {
            this.logger.error("vivo\u91cd\u8bd5\u83b7\u53d6token\u5931\u8d25");
            return;
        }
        String authToken = (String)this.redisStringAdapter.get(RedisConfig.VIVO_ACCESS_TOKEN, String.class);
        Long expiredMills = (Long)this.redisStringAdapter.get(RedisConfig.VIVO_ACCESS_TOKEN_EXPIRED, Long.class);
        if (null == authToken || expiredMills < System.currentTimeMillis()) {
            String unlockKey = UUIDUtils.nextID();
            if (this.distributedLock.lock(LOCK_RESOURCE_KEY, unlockKey)) {
                try {
                    Result token = this.sender.getToken(this.appPushProperties.getVivoAppId(), this.appPushProperties.getVivoAppKey());
                    authToken = token.getAuthToken();
                    if (StringUtils.isBlank((CharSequence)authToken)) {
                        this.logger.error("\u83b7\u53d6vivo token\u5931\u8d25\uff0c\u6388\u6743token\u4e3a\u7a7a");
                        this.refreshToken(--maxAttempts);
                        return;
                    }
                    expiredMills = System.currentTimeMillis() + 5400000L;
                    this.redisStringAdapter.set(RedisConfig.VIVO_ACCESS_TOKEN, (Object)authToken, DEFAULT_EXPIRED_SECONDS.longValue());
                    this.redisStringAdapter.set(RedisConfig.VIVO_ACCESS_TOKEN_EXPIRED, (Object)expiredMills);
                    log.info("\u5237\u65b0vivo token,token\u503c:{},\u8fc7\u671f\u65f6\u95f4:{}", (Object)authToken, (Object)expiredMills);
                    this.distributedLock.unlock(LOCK_RESOURCE_KEY, unlockKey);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.refreshToken(--maxAttempts);
                    return;
                }
            } else {
                try {
                    Thread.sleep(500L);
                    log.info("\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6token\u65f6\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25, \u91cd\u8bd5\u6b21\u6570: {}", (Object)maxAttempts);
                    this.refreshToken(--maxAttempts);
                    return;
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.initLocalCache(authToken, expiredMills - System.currentTimeMillis());
        this.sender.setAuthToken(authToken);
    }
}

