/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.domain.MsgGroupPushCounterMapper;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageGroupCounterServiceImpl
implements MessageGroupCounterService {
    private static final Logger log = LoggerFactory.getLogger(MessageGroupCounterServiceImpl.class);
    private final MsgGroupPushCounterMapper msgGroupPushCounterMapper;
    private final SequenceCreater sequenceCreater;
    private AtomicBoolean init = new AtomicBoolean(false);
    private LinkedBlockingQueue<MsgGroupPushCounterBean> counterQueue = new LinkedBlockingQueue(10000);

    @Autowired
    public MessageGroupCounterServiceImpl(MsgGroupPushCounterMapper msgGroupPushCounterMapper, SequenceCreater sequenceCreater) {
        this.msgGroupPushCounterMapper = msgGroupPushCounterMapper;
        this.sequenceCreater = sequenceCreater;
    }

    private void initConsumerThread() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("consumer-counter", true));
        executor.scheduleAtFixedRate(this::execBatchSave, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void execBatchSave() {
        try {
            ArrayListMultimap counterMap = ArrayListMultimap.create();
            int batchSize = 0;
            while (CollectionUtils.isNotEmpty(this.counterQueue)) {
                MsgGroupPushCounterBean counter = this.counterQueue.poll();
                if (null == counter) continue;
                Collection counterList = counterMap.get((Object)counter.getGroupMsgId());
                boolean hit = false;
                if (CollectionUtils.isNotEmpty((Collection)counterList)) {
                    for (MsgGroupPushCounterBean subCounter : counterList) {
                        if (!Objects.equals(subCounter.getGroupMsgId(), counter.getGroupMsgId()) || !Objects.equals(subCounter.getPushType(), counter.getPushType())) continue;
                        subCounter.setFail(Integer.valueOf(this.sum(counter.getFail(), subCounter.getFail())));
                        subCounter.setSuccess(Integer.valueOf(this.sum(counter.getSuccess(), subCounter.getSuccess())));
                        subCounter.setCallback(Integer.valueOf(this.sum(counter.getCallback(), subCounter.getCallback())));
                        hit = true;
                    }
                }
                if (!hit) {
                    counterMap.put((Object)counter.getGroupMsgId(), (Object)counter);
                }
                if (batchSize > 1000) {
                    this.saveBatch((Multimap<Long, MsgGroupPushCounterBean>)counterMap);
                    counterMap = ArrayListMultimap.create();
                    break;
                }
                ++batchSize;
            }
            if (counterMap.size() > 0) {
                this.saveBatch((Multimap<Long, MsgGroupPushCounterBean>)counterMap);
            }
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39\u7fa4\u63a8\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c\u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a{}", (Object)this.counterQueue.size());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveBatch(Multimap<Long, MsgGroupPushCounterBean> counterMap) {
        for (MsgGroupPushCounterBean counter : counterMap.values()) {
            log.info("\u5199\u5165\u4e00\u6b21\u7edf\u8ba1\u6570\u636e\uff0cmsgId:{},success\uff1a{},fail:{},callback:{}", new Object[]{counter.getGroupMsgId(), counter.getSuccess(), counter.getFail(), counter.getCallback()});
            this.msgGroupPushCounterMapper.addCounter(counter);
        }
    }

    private int sum(Integer num, Integer subNum) {
        if (num == null) {
            num = 0;
        }
        if (subNum == null) {
            subNum = 0;
        }
        return num + subNum;
    }

    @Override
    public void saveCounter(PushMessage message) {
        log.info("\u521d\u59cb\u5316\u6d88\u606f\u7edf\u8ba1\u6570\u636e\uff0cmsgId:{}", (Object)message.getMsgId());
        this.msgGroupPushCounterMapper.deleteByMsgId(message.getMsgId());
        for (PlatformTypeEnum platformType : PlatformTypeEnum.values()) {
            if (!platformType.isApp()) continue;
            MsgGroupPushCounterBean pushCounter = MsgGroupPushCounterBean.builder().id(this.sequenceCreater.nextLongId()).groupMsgId(message.getMsgId()).callback(Integer.valueOf(0)).fail(Integer.valueOf(0)).success(Integer.valueOf(0)).pushType(Byte.valueOf(platformType.getCode())).createTime(new Date()).build();
            this.msgGroupPushCounterMapper.insert(pushCounter);
        }
    }

    @Override
    public void addCounter(MsgGroupPushCounterBean counter) {
        if (this.init.compareAndSet(false, true)) {
            this.initConsumerThread();
        }
        if (!this.counterQueue.offer(counter)) {
            log.error("\u961f\u5217\u5df2\u6ee1\uff0c\u4e22\u5f03\u5199\u5165\u6570\u636e\uff1a{}", (Object)counter);
        }
    }

    @Override
    public List<MsgGroupPushCounterBean> getMessageCounter(Long msgId) {
        return this.msgGroupPushCounterMapper.getMesageCounter(msgId);
    }
}

