/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.SendTypeEunm;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.constant.PushMsgConstant;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.domain.MsgGroupPushMapper;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.param.PushMsgBuildParam;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.PushMessageDispatcher;
import com.bxm.localnews.msg.service.impl.PushMessageHandler;
import com.bxm.localnews.msg.timer.PushMessageTask;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.vo.Message;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageGroupServiceImpl
implements MessageGroupService {
    private static final Logger log = LoggerFactory.getLogger(MessageGroupServiceImpl.class);
    private final MsgGroupPushMapper msgGroupPushMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final PushMessageHandler pushMessageHandler;
    private final ScheduleService scheduleService;
    private final PushMessageTask pushMessageTask;
    private final PushMessageDispatcher dispatcher;
    private LoadingCache<Long, PushMessage> cache;
    private LoadingCache<Long, Boolean> blackCache;

    @Autowired
    public MessageGroupServiceImpl(MsgGroupPushMapper msgGroupPushMapper, RedisStringAdapter redisStringAdapter, PushMessageHandler pushMessageHandler, ScheduleService scheduleService, PushMessageTask pushMessageTask, PushMessageDispatcher dispatcher) {
        this.msgGroupPushMapper = msgGroupPushMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.pushMessageHandler = pushMessageHandler;
        this.scheduleService = scheduleService;
        this.pushMessageTask = pushMessageTask;
        this.dispatcher = dispatcher;
        this.initLocalCache();
    }

    @Override
    public Message save(MsgGroupPushBean groupPushBean) {
        int result;
        Date now = new Date();
        if (groupPushBean.getId() == null) {
            groupPushBean.setId(this.incrementMsgId());
            groupPushBean.setCreateTime(now);
            groupPushBean.setUserTotal(Integer.valueOf(0));
            groupPushBean.setModifyTime(now);
            if (groupPushBean.getPeriodTime() == null) {
                groupPushBean.setPeriodTime(Integer.valueOf(24));
            }
            groupPushBean.setStatus(PushMessageStatusEnum.STAY_CONFIRM.getType());
            result = this.msgGroupPushMapper.insert(groupPushBean);
        } else {
            MsgGroupPushBean existsGroupMsg = this.msgGroupPushMapper.selectByPrimaryKey(groupPushBean.getId());
            if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(existsGroupMsg.getStatus()) || PushMessageStatusEnum.BEING_SEND.getType().equals(existsGroupMsg.getStatus())) {
                return Message.build((boolean)false, (String)"\u6d88\u606f\u63a8\u9001\u4e2d\u6216\u5df2\u63a8\u9001\uff0c\u65e0\u6cd5\u7f16\u8f91");
            }
            groupPushBean.setModifyTime(now);
            result = this.msgGroupPushMapper.updateByPrimaryKeySelective(groupPushBean);
        }
        if (SendTypeEunm.SEND_NOW.getType().equals(String.valueOf(groupPushBean.getIsTiming()))) {
            this.removeTimer(groupPushBean.getId());
            this.removeBlack(groupPushBean.getId());
        } else if (SendTypeEunm.SEND_TIMING.getType().equals(String.valueOf(groupPushBean.getIsTiming()))) {
            this.removeBlack(groupPushBean.getId());
        }
        return Message.build((int)result);
    }

    @Override
    public Message pushNow(MsgGroupPushBean groupPushBean) {
        this.dispatcher.push(this.pushMessageHandler.generateMessage(groupPushBean));
        this.removeBlack(groupPushBean.getId());
        MsgGroupPushBean modifyPushInfo = new MsgGroupPushBean();
        modifyPushInfo.setId(groupPushBean.getId());
        modifyPushInfo.setPushTime(new Date());
        modifyPushInfo.setStatus(groupPushBean.getStatus());
        this.msgGroupPushMapper.updateByPrimaryKeySelective(groupPushBean);
        return Message.build();
    }

    @Override
    public void createTimer(MsgGroupPushBean entity) {
        PushMsgBuildParam timerParam = new PushMsgBuildParam();
        timerParam.setMessageId(entity.getId());
        timerParam.setPushMessage(this.pushMessageHandler.generateMessage(entity));
        timerParam.setStartTime(entity.getPushTime());
        this.removeTimer(entity.getId());
        this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((String)PushMessageTask.generateTaskName(entity.getId()), (Date)timerParam.getStartTime(), (TaskCallback)this.pushMessageTask).callbackParam((Object)timerParam).build());
    }

    private void removeTimer(Long msgId) {
        String taskName = PushMessageTask.generateTaskName(msgId);
        log.info("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1:{}", (Object)taskName);
        this.scheduleService.remove(taskName);
    }

    @Override
    public Long incrementMsgId() {
        return this.redisStringAdapter.incrementWithDefault(RedisConfig.INCREMENT_STATISTICS_MSG_ID, PushMsgConstant.MIN_STATISTICS_MSG_ID.longValue());
    }

    @Override
    public boolean isGroupMsg(Long msgId) {
        if (msgId == null) {
            return false;
        }
        return msgId > PushMsgConstant.MIN_STATISTICS_MSG_ID && msgId < PushMsgConstant.MAX_STATISTICS_MSG_ID;
    }

    private void removeBlack(Long msgId) {
        this.redisStringAdapter.remove(RedisConfig.BLACK_MSG_ID.copy().appendKey((Object)msgId));
    }

    private void addBlack(Long msgId) {
        this.redisStringAdapter.set(RedisConfig.BLACK_MSG_ID.copy().appendKey((Object)msgId), (Object)Boolean.TRUE, 86400L);
    }

    @Override
    public boolean isBlackMsgId(Long msgId) {
        Boolean hit = (Boolean)this.blackCache.getUnchecked((Object)msgId);
        return Boolean.TRUE.equals(hit);
    }

    @Override
    public Message changeStatus(Long msgId, PushMessageStatusEnum status) {
        if (null == status) {
            return Message.build((boolean)false, (String)"\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        }
        if (null == msgId) {
            return Message.build((boolean)false, (String)"\u8be5\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        MsgGroupPushBean updateEntity = new MsgGroupPushBean();
        updateEntity.setId(msgId);
        updateEntity.setStatus(status.getType());
        if (PushMessageStatusEnum.CANCEL.equals((Object)status)) {
            this.removeTimer(msgId);
            this.addBlack(msgId);
        }
        if (PushMessageStatusEnum.STAY_CONFIRM.equals((Object)status)) {
            this.removeTimer(msgId);
        }
        if (PushMessageStatusEnum.STAY_SEND.equals((Object)status)) {
            this.removeBlack(msgId);
        }
        int result = this.msgGroupPushMapper.updateByPrimaryKeySelective(updateEntity);
        this.cache.refresh((Object)msgId);
        return Message.build((int)result);
    }

    @Override
    public PushMessage loadCache(Long msgId, boolean forceRefresh) {
        if (forceRefresh) {
            this.cache.refresh((Object)msgId);
        }
        return (PushMessage)this.cache.getUnchecked((Object)msgId);
    }

    @Override
    public MsgGroupPushBean get(Long msgId) {
        return this.msgGroupPushMapper.selectByPrimaryKey(msgId);
    }

    @Override
    public List<MsgGroupPushBean> getGroupMessageByPage(PushMessageParam param) {
        return this.msgGroupPushMapper.selectByPage(param);
    }

    @Override
    public void addPushTotal(Long msgId, int userTotal) {
        this.msgGroupPushMapper.addUserTotal(msgId, Integer.valueOf(userTotal));
    }

    private void initLocalCache() {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, PushMessage>(){

            public PushMessage load(Long key) {
                MsgGroupPushBean msgGroupPushBean = MessageGroupServiceImpl.this.msgGroupPushMapper.selectByPrimaryKey(key);
                if (null != msgGroupPushBean) {
                    return MessageGroupServiceImpl.this.pushMessageHandler.generateMessage(msgGroupPushBean);
                }
                return null;
            }
        });
        this.blackCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long key) {
                return Boolean.TRUE.equals(MessageGroupServiceImpl.this.redisStringAdapter.get(RedisConfig.BLACK_MSG_ID.copy().appendKey((Object)key), Boolean.class));
            }
        });
    }
}

