/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.oppo.push.server.Notification;
import com.oppo.push.server.Result;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Target;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class OppoPushPlatform
extends AbstractPushPlatform
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OppoPushPlatform.class);
    private static final int SUCCESS_CODE = 0;
    private Sender sender;
    private AtomicBoolean init = new AtomicBoolean(false);

    private void initSender() {
        if (this.init.compareAndSet(false, true)) {
            try {
                this.sender = new Sender(this.appPushProperties.getOppoAppKey(), this.appPushProperties.getOppoAppSecret());
            }
            catch (Exception e) {
                this.logger.error("oppo \u63a8\u9001\u521d\u59cb\u5316\u5931\u8d25");
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        if (this.sender == null) {
            callback.apply(message, userToken, Response.fail("init failed"));
            return;
        }
        Notification notification = this.buildNotification(message);
        Target target = Target.build((String)userToken.getToken());
        try {
            Result result = this.sender.unicastNotification(notification, target);
            log.debug("\u63a8\u9001\u7ed3\u679c\uff1a{},\u63a8\u9001\u5185\u5bb9\uff1a{}", (Object)result, (Object)message);
            if (0 == result.getReturnCode().getCode()) {
                callback.apply(message, userToken, Response.success());
            } else {
                log.info("OPPO\u63a8\u9001\u5931\u8d25\uff0c\u5931\u8d25\u7ed3\u679c\uff1a{},\u63a8\u9001\u53c2\u6570\uff1a{}", (Object)result, (Object)message);
                callback.apply(message, userToken, Response.fail("failed"));
            }
        }
        catch (Exception e) {
            callback.apply(message, userToken, Response.fail(e.getMessage()));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Notification buildNotification(PushMessage pushMessage) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("message", (Object)pushMessage.getPayloadInfo().toJsonString());
        Notification notification = new Notification();
        notification.setTitle(pushMessage.getTitle());
        notification.setContent(pushMessage.getContent());
        notification.setStyle(Integer.valueOf(1));
        notification.setChannelId("11111");
        notification.setAppMessageId(pushMessage.getPayloadInfo().getMsgId().toString());
        notification.setClickActionType(Integer.valueOf(4));
        notification.setClickActionActivity("com.receiver.PushRouteActivity");
        notification.setActionParameters(paramJson.toJSONString());
        notification.setNetworkType(Integer.valueOf(0));
        return notification;
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.OPPO;
    }

    public void afterPropertiesSet() throws Exception {
        this.initSender();
        if (this.sender == null) {
            throw new IllegalArgumentException("\u521d\u59cb\u5316oppo\u63a8\u9001\u5e73\u53f0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u5bf9\u5e94\u7684\u53c2\u6570");
        }
    }
}

