/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.push;

public class Response {
    private String message;
    private boolean success;
    private boolean tokenExpired;

    private Response() {
    }

    public static Response success(String message) {
        Response response = new Response();
        response.success = true;
        response.tokenExpired = false;
        response.message = message;
        return response;
    }

    public static Response success() {
        Response response = new Response();
        response.success = true;
        response.tokenExpired = false;
        return response;
    }

    public static Response fail(String message) {
        Response response = new Response();
        response.success = false;
        response.tokenExpired = false;
        response.message = message;
        return response;
    }

    public static Response expire(String message) {
        Response response = new Response();
        response.success = false;
        response.tokenExpired = true;
        response.message = message;
        return response;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isTokenExpired() {
        return this.tokenExpired;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setTokenExpired(boolean tokenExpired) {
        this.tokenExpired = tokenExpired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        return this.isTokenExpired() == other.isTokenExpired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isTokenExpired() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Response(message=" + this.getMessage() + ", success=" + this.isSuccess() + ", tokenExpired=" + this.isTokenExpired() + ")";
    }
}

