/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.config;

import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.bxm.localnews.mq.config.AliyunMqProperties;
import com.bxm.localnews.mq.consume.listener.DefaultMessageListener;
import com.bxm.localnews.mq.consume.listener.PushMessageListener;
import com.bxm.localnews.mq.consume.listener.SmsMessageListener;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnProperty(prefix="aliyun.mq", value={"access-key"})
@EnableConfigurationProperties(value={AliyunMqProperties.class})
public class AliyunMqConsumeConfiguration {
    @Resource
    private AliyunMqProperties aliyunMqProperties;
    @Resource
    private DefaultMessageListener defaultMessageListener;
    @Resource
    private SmsMessageListener smsMessageListener;
    @Resource
    private PushMessageListener pushMessageListener;

    @Bean(initMethod="start", destroyMethod="shutdown")
    public ConsumerBean consumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();
        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        consumerBean.setProperties(properties);
        HashMap subscriptionTable = Maps.newHashMap();
        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getTopic());
        subscription.setExpression("*");
        this.defaultMessageListener.init();
        subscriptionTable.put(subscription, this.defaultMessageListener);
        consumerBean.setSubscriptionTable((Map)subscriptionTable);
        return consumerBean;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public ConsumerBean smsConsumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();
        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getSmsConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        consumerBean.setProperties(properties);
        HashMap subscriptionTable = Maps.newHashMap();
        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getSmsTopic());
        subscription.setExpression("*");
        subscriptionTable.put(subscription, this.smsMessageListener);
        consumerBean.setSubscriptionTable((Map)subscriptionTable);
        return consumerBean;
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public ConsumerBean pushConsumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();
        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getPushConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        consumerBean.setProperties(properties);
        HashMap subscriptionTable = Maps.newHashMap();
        Subscription subscription = new Subscription();
        subscription.setTopic(this.aliyunMqProperties.getPushTopic());
        subscription.setExpression("*");
        subscriptionTable.put(subscription, this.pushMessageListener);
        consumerBean.setSubscriptionTable((Map)subscriptionTable);
        return consumerBean;
    }
}

