/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.config;

import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.bxm.localnews.mq.config.AliyunMqProperties;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnProperty(prefix="aliyun.mq", value={"access-key"})
@EnableConfigurationProperties(value={AliyunMqProperties.class})
public class AliyunMqProduceConfiguration {
    @Resource
    private AliyunMqProperties aliyunMqProperties;

    @Bean(name={"producer"}, initMethod="start", destroyMethod="shutdown")
    public ProducerBean producerBean() {
        ProducerBean producerBean = new ProducerBean();
        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        producerBean.setProperties(properties);
        return producerBean;
    }

    @Bean(name={"mpProducer"}, initMethod="start", destroyMethod="shutdown")
    public ProducerBean mpProducer() {
        ProducerBean producerBean = new ProducerBean();
        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getMpProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        producerBean.setProperties(properties);
        return producerBean;
    }

    @Bean(name={"smsProducer"}, initMethod="start", destroyMethod="shutdown")
    public ProducerBean smsProducer() {
        ProducerBean producerBean = new ProducerBean();
        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getSmsProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        producerBean.setProperties(properties);
        return producerBean;
    }

    @Bean(name={"pushProducer"}, initMethod="start", destroyMethod="shutdown")
    public ProducerBean pushProducer() {
        ProducerBean producerBean = new ProducerBean();
        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getPushProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());
        producerBean.setProperties(properties);
        return producerBean;
    }
}

