/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.mq.consume.consumer.TagMessageConsumer;
import com.bxm.localnews.msg.domain.NewsStatisticsConsumeMapper;
import com.bxm.newidea.component.tools.StringUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewsRecommendTagConsumer
implements TagMessageConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsRecommendTagConsumer.class);
    @Resource
    private NewsStatisticsConsumeMapper newsStatisticsConsumeMapper;

    @Override
    public boolean support(String tag) {
        return "news_recommended".equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsRecommended(message);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("\u6d88\u8d39\u6210\u529f\uff0c\u6d88\u606f\u5185\u5bb9\uff1a" + message);
        return Action.CommitMessage;
    }

    private void newsRecommended(Message message) {
        Long userId = Long.valueOf(message.getUserProperties("user_id"));
        String newsIds = message.getUserProperties("remended_ids");
        String[] newsIdArray = StringUtils.split((String)newsIds, (String)",");
        new BatchHelper<NewsStatisticsConsumeMapper, String>(NewsStatisticsConsumeMapper.class, newsIdArray){

            protected int invoke(String element) {
                return ((NewsStatisticsConsumeMapper)this.mapper).recommended(Long.valueOf(element));
            }
        };
    }
}

