/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.listener;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.consume.consumer.TagMessageConsumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultMessageListener
implements MessageListener,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageListener.class);
    private ApplicationContext applicationContext;
    private Collection<TagMessageConsumer> consumers;
    private BlockingQueue queue;

    public Action consume(Message message, ConsumeContext context) {
        Action result = Action.ReconsumeLater;
        String tag = message.getTag();
        LOGGER.debug("tag:[{}],consume message:[{}]", (Object)tag, (Object)message);
        for (TagMessageConsumer consumer : this.consumers) {
            if (!consumer.support(tag)) continue;
            LOGGER.debug("consumer:[{}][{}]", (Object)consumer, (Object)tag);
            result = consumer.consume(message, context);
            if (!Action.CommitMessage.equals((Object)result)) continue;
            return result;
        }
        return result;
    }

    public void addConsume(TagMessageConsumer consumer) {
        this.consumers.add(consumer);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        Map consumer = this.applicationContext.getBeansOfType(TagMessageConsumer.class);
        if (consumer.size() > 0) {
            this.consumers = consumer.values().stream().sorted(Comparator.comparingInt(TagMessageConsumer::order)).collect(Collectors.toList());
        } else {
            LOGGER.warn("\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u6ce8\u518c\u7684\u6d88\u8d39\u8005");
        }
    }
}

