/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.listener;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.consume.push.PushMessageDispatcher;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PushMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(PushMessageListener.class);
    @Resource
    private PushMessageDispatcher pushMessageDispatcher;
    @Resource
    private ObjectMapper objectMapper;

    public Action consume(Message message, ConsumeContext consumeContext) {
        try {
            String msg = new String(message.getBody());
            PushMessage pushMessage = (PushMessage)this.objectMapper.readValue(msg, PushMessage.class);
            if (null == pushMessage || !pushMessage.valid()) {
                logger.error("message parse failed:{}", (Object)message);
                return Action.CommitMessage;
            }
            Optional tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag((String)message.getTag());
            if (tagEnumOptional.isPresent() && AliMqMsgTagEnum.PUSH.equals(tagEnumOptional.get())) {
                this.pushMessageDispatcher.push(pushMessage);
                return Action.CommitMessage;
            }
            logger.error("illegal tag,messgea:{}", (Object)message);
            return Action.ReconsumeLater;
        }
        catch (Exception e) {
            logger.error("message consume failed:{}", (Object)message);
            logger.error(e.getMessage(), (Throwable)e);
            return Action.ReconsumeLater;
        }
    }
}

