/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.listener;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.config.MessageProperties;
import com.bxm.localnews.mq.config.SmsOperatorConfig;
import com.bxm.localnews.mq.consume.service.SmsFactory;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class SmsMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageListener.class);
    @Resource
    private SmsOperatorConfig smsOperatorConfig;
    @Resource
    private MessageProperties messageProperties;

    public Action consume(Message message, ConsumeContext consumeContext) {
        if (!this.messageProperties.getEnableSms().booleanValue()) {
            logger.debug("\u77ed\u4fe1\u672a\u5f00\u542f");
            logger.debug(new String(message.getBody()));
            return Action.CommitMessage;
        }
        try {
            String msg = new String(message.getBody());
            JSONObject smsJson = JSONObject.parseObject((String)msg);
            if ("shiyuan".equals(this.smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send((byte)10, smsJson.getString("phoneNo"), smsJson.getString("content"));
                if (!result[0].equals("1")) {
                    logger.error("\u77ed\u4fe1\u6d88\u8d39\u5931\u8d25:" + result[0] + ":" + result[1], (Object)(smsJson.getString("phoneNo") + ":" + smsJson.getString("content")));
                    return Action.ReconsumeLater;
                }
                logger.debug("\u77ed\u4fe1\u6d88\u8d39\u6210\u529f", (Object)(result[0] + "," + result[1]));
            }
            return Action.CommitMessage;
        }
        catch (Exception e) {
            logger.error("\u77ed\u4fe1\u6d88\u8d39\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return Action.ReconsumeLater;
        }
    }
}

