/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.consume.push.platform.IPushPlatform;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.mq.consume.push.receive.ReceiveUserFactory;
import com.bxm.localnews.msg.domain.PushMessageMapper;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PushMessageDispatcher
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushMessageDispatcher.class);
    private final ReceiveUserFactory receiveUserManage;
    private final AsyncTaskExecutor asyncTaskExecutor;
    private final PushMessageMapper pushMessageMapper;
    private Map<PlatformTypeEnum, IPushPlatform> pushPlatformMap;
    private ApplicationContext applicationContext;

    @Autowired
    public PushMessageDispatcher(ReceiveUserFactory receiveUserManage, AsyncTaskExecutor asyncTaskExecutor, PushMessageMapper pushMessageMapper) {
        this.receiveUserManage = receiveUserManage;
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.pushMessageMapper = pushMessageMapper;
    }

    public void push(PushMessage message) {
        LOGGER.debug("\u6d88\u606f\u63a8\u9001\u5f00\u59cb,message:{}", (Object)message);
        PushReceiveScope receiveScope = message.getPushReceiveScope();
        IReceiveUserIterator iterator = this.receiveUserManage.get(receiveScope.getPushReceiverRule(), receiveScope.getRuleParam());
        List platformTypes = message.getPushReceiveScope().getPlatformTypes();
        while (iterator.hasNext()) {
            Map userMap = (Map)iterator.next();
            this.asyncTaskExecutor.execute(() -> userMap.forEach((type, users) -> {
                if (!CollectionUtils.isEmpty((Collection)platformTypes)) {
                    for (PlatformTypeEnum platform : platformTypes) {
                        if (!platform.equals(type)) continue;
                        this.pushPlatformMap.get(type).push(message, (List<UserDeviceBean>)users);
                    }
                } else {
                    this.pushPlatformMap.get(type).push(message, (List<UserDeviceBean>)users);
                }
            }));
        }
        this.pushMessageMapper.updateStats(message.getPayloadInfo().getMsgId(), 2);
        LOGGER.debug("\u6d88\u606f\u63a8\u9001\u7ed3\u675f,message:{}", (Object)message);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map pushPlatormBeanMap = this.applicationContext.getBeansOfType(IPushPlatform.class);
        if (pushPlatormBeanMap.size() == 0) {
            throw new IllegalArgumentException("push platform is emtpy");
        }
        this.pushPlatformMap = Maps.newHashMap();
        pushPlatormBeanMap.forEach((key, value) -> this.pushPlatformMap.put(value.getType(), (IPushPlatform)value));
    }
}

