/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.platform.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.RedisConfig;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.consume.push.platform.IPushPlatform;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.domain.PushMessageMapper;
import com.bxm.localnews.msg.domain.PushUserMapper;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.localnews.msg.vo.PushUserBean;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPushPlatform
implements IPushPlatform {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private PushUserMapper pushUserMapper;
    @Autowired
    private PushMessageMapper pushMessageMapper;
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public void push(PushMessage message, List<UserDeviceBean> userDevice) {
        if (userDevice.size() > 0) {
            if (userDevice.size() == 1) {
                this.singlePush(message, userDevice.get(0));
            } else {
                this.groupPush(message, userDevice);
            }
            this.changePushNum(message, userDevice);
        }
    }

    private void changePushNum(PushMessage message, List<UserDeviceBean> userDevice) {
        if (!PushReceiverRuleEnum.DEFAULT.equals((Object)message.getPushReceiveScope().getPushReceiverRule())) {
            this.pushMessageMapper.updateNum(message.getPayloadInfo().getMsgId(), userDevice.size());
        }
    }

    void callback(PushMessage message, UserDeviceBean user, String response) {
        this.callback(message, (List<UserDeviceBean>)ImmutableList.of((Object)user), response);
    }

    void callback(final PushMessage message, List<UserDeviceBean> users, final String response) {
        new BatchHelper<PushUserMapper, UserDeviceBean>(PushUserMapper.class, users){

            protected int invoke(UserDeviceBean element) {
                PushUserBean entity = new PushUserBean();
                entity.setId(AbstractPushPlatform.this.sequenceCreater.nextLongId());
                entity.setChecked(0);
                entity.setMessageId(message.getPayloadInfo().getMsgId());
                entity.setPlatform(element.getPlatform());
                entity.setUserId(element.getUserId());
                entity.setPushTime(new Date());
                entity.setPushResult(response);
                return ((PushUserMapper)this.mapper).insert(entity);
            }
        };
        if (message.isPersistence()) {
            this.doPersistence(message, users);
        }
    }

    private void doPersistence(PushMessage message, List<UserDeviceBean> users) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        for (UserDeviceBean userDeviceBean : users) {
            Message messageVo = new Message();
            messageVo.setTitle(message.getTitle());
            messageVo.setContent(message.getContent());
            messageVo.setUserId(userDeviceBean.getUserId());
            messageVo.setMsgType(String.valueOf(message.getPayloadInfo().getType()));
            messageVo.setStatus(Byte.valueOf((byte)0));
            messageVo.setLinkParam(JSON.toJSONString((Object)message.getPayloadInfo()));
            messageList.add(messageVo);
        }
        new BatchHelper<MessageMapper, Message>(MessageMapper.class, messageList){

            protected int invoke(Message element) {
                KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey((Object)element.getUserId());
                AbstractPushPlatform.this.redisStringAdapter.set(redPointKey, (Object)true);
                return ((MessageMapper)this.mapper).insertSelective(element);
            }
        };
    }

    abstract void singlePush(PushMessage var1, UserDeviceBean var2);

    abstract void groupPush(PushMessage var1, List<UserDeviceBean> var2);

    boolean isIOS(UserDeviceBean userDevice) {
        return null != userDevice && null != userDevice.getPhoneModel() && userDevice.getPhoneModel().indexOf("iPhone") != -1;
    }
}

