/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.consume.push.platform.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.config.AppPushProperties;
import com.bxm.localnews.mq.consume.push.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class GetuiPushPlatform
extends AbstractPushPlatform {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetuiPushPlatform.class);
    @Resource
    private AppPushProperties appPushProperties;
    private IGtPush iGtPush;

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.GETUI;
    }

    @Override
    void singlePush(PushMessage message, UserDeviceBean userDevice) {
        System.setProperty("gexin.rp.sdk.pushlist.needDetails", "true");
        IGtPush push = this.getIgtpush();
        TransmissionTemplate template = null;
        this.logger.debug("\u6d88\u606f\u63a8\u9001\u7c7b\u578b\u4e3a\uff1a[{}]", (Object)message.getType());
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)message.getType()) && !this.isIOS(userDevice)) {
            this.logger.debug("\u5f53\u524d\u63a8\u9001\u7684\u7528\u6237id[{}]--\u624b\u673a\u578b\u53f7[{}]\u53d1\u9001\u901a\u77e5\u7c7b\u578b\u7684\u6d88\u606f", (Object)userDevice.getUserId(), (Object)userDevice.getPhoneModel());
            template = this.notificationTemplate(message);
        } else {
            this.logger.debug("\u5f53\u524d\u63a8\u9001\u7684\u7528\u6237id[{}]--\u624b\u673a\u578b\u53f7[{}]\u53d1\u9001\u900f\u4f20\u7c7b\u578b\u7684\u6d88\u606f", (Object)userDevice.getUserId(), (Object)userDevice.getPhoneModel());
            template = this.transmissionTemplate(message);
        }
        SingleMessage singleMessage = new SingleMessage();
        singleMessage.setOffline(true);
        singleMessage.setOfflineExpireTime((long)(message.getPeriodTime() * 3600 * 1000));
        singleMessage.setData((ITemplate)template);
        singleMessage.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(this.appPushProperties.getId());
        if (StringUtils.isNotBlank((CharSequence)userDevice.getPushToken())) {
            target.setClientId(userDevice.getPushToken());
        } else {
            target.setAlias(userDevice.getUserId().toString());
        }
        IPushResult ret = push.pushMessageToSingle(singleMessage, target);
        String response = null;
        if (null != ret && ret.getResponse() != null) {
            response = JSON.toJSONString((Object)ret.getResponse());
        }
        this.callback(message, userDevice, response);
    }

    @Override
    void groupPush(PushMessage message, List<UserDeviceBean> userDevice) {
        for (UserDeviceBean userDeviceBean : userDevice) {
            this.singlePush(message, userDeviceBean);
        }
    }

    private TransmissionTemplate transmissionTemplate(PushMessage pushMessage) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.appPushProperties.getId());
        template.setAppkey(this.appPushProperties.getKey());
        template.setTransmissionType(2);
        template.setTransmissionContent(pushMessage.getPayloadInfo().toJsonString());
        template.setAPNInfo((Payload)this.buildApnPayload(pushMessage));
        return template;
    }

    private NotificationTemplate notificationTemplate(PushMessage pushMessage) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appPushProperties.getId());
        template.setAppkey(this.appPushProperties.getKey());
        template.setTransmissionType(1);
        template.setTransmissionContent(pushMessage.getPayloadInfo().toJsonString());
        template.setAPNInfo((Payload)this.buildApnPayload(pushMessage));
        Style0 style = new Style0();
        style.setTitle(pushMessage.getTitle());
        style.setText(pushMessage.getContent());
        style.setRing(!pushMessage.isMute());
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        return template;
    }

    private APNPayload buildApnPayload(PushMessage pushMessage) {
        APNPayload payload = new APNPayload();
        payload.setAutoBadge("+1");
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)pushMessage.getType())) {
            payload.setContentAvailable(1);
        } else {
            payload.setContentAvailable(0);
        }
        if (pushMessage.isMute()) {
            payload.setSound(PushSoundEnum.IOS_MUTE.getIosSound());
        } else {
            payload.setSound(pushMessage.getSound().getIosSound());
        }
        APNPayload.DictionaryAlertMsg dictionaryAlertMsg = new APNPayload.DictionaryAlertMsg();
        if (!PushMessageEnum.getMessageSilenceByType((int)pushMessage.getPayloadInfo().getType()).booleanValue()) {
            dictionaryAlertMsg.setTitle(pushMessage.getTitle());
            dictionaryAlertMsg.setBody(pushMessage.getContent());
        } else {
            payload.setContentAvailable(0);
        }
        payload.setAlertMsg((APNPayload.AlertMsg)dictionaryAlertMsg);
        payload.addCustomMsg("payload", (Object)pushMessage.getPayloadInfo().toJsonString());
        return payload;
    }

    private IGtPush getIgtpush() {
        if (null == this.iGtPush) {
            this.iGtPush = new IGtPush(this.appPushProperties.getHost(), this.appPushProperties.getKey(), this.appPushProperties.getMasterSecret());
        }
        return this.iGtPush;
    }
}

